package com.cdk.core.security.dto;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonRootName;

/**
 * Token Request class for IAM token
 * 
    {
      tokenId=eba96ee4-ed59-4c3d-a871-13b6aa86e037,
      deviceId=163321035,
      deviceType=Android,
      comments=createdbyadmin,
      expirationTimestamp=2018-10-28T00: 00: 00-0700,
      createdBy=Admin,
      modifiedBy=Admin
    }
 * 
 * @author Kevendra Patidar
 */
@JsonIgnoreProperties(ignoreUnknown = true)
@JsonRootName("tokenRequest")//need to post and create long term token 
public class OAuthTokenDto {

	/* ************************************ Instance Fields ************************************ */
    private String tokenId;
    private String deviceId;
    private String deviceType;
    private String comments;
    //@DateTimeFormat(pattern="yyyy-MM-dd'T'HH:mm:ssZ")
    private Date expirationTimestamp;
    private String createdBy;
    private String modifiedBy;
    
	/* ************************************ Public Methods ************************************ */
	@Override
	public String toString() {
		return "OAuthTokenRequest [tokenId=" + tokenId + ", deviceId="
				+ deviceId + ", deviceType=" + deviceType + ", comments="
				+ comments + ", expirationTimestamp=" + expirationTimestamp
				+ ", createdBy=" + createdBy + ", modifiedBy=" + modifiedBy
				+ "]";
	}
    
	/* ************************************ Getters and Setters ************************************ */
	public String getTokenId() {
		return tokenId;
	}
	public void setTokenId(String tokenId) {
		this.tokenId = tokenId;
	}
	public String getDeviceId() {
		return deviceId;
	}
	public void setDeviceId(String deviceId) {
		this.deviceId = deviceId;
	}
	public String getDeviceType() {
		return deviceType;
	}
	public void setDeviceType(String deviceType) {
		this.deviceType = deviceType;
	}
	public String getComments() {
		return comments;
	}
	public void setComments(String comments) {
		this.comments = comments;
	}
	public Date getExpirationTimestamp() {
		return expirationTimestamp;
	}
	public void setExpirationTimestamp(Date expirationTimestamp) {
		this.expirationTimestamp = expirationTimestamp;
	}
	public String getCreatedBy() {
		return createdBy;
	}
	public void setCreatedBy(String createdBy) {
		this.createdBy = createdBy;
	}
	public String getModifiedBy() {
		return modifiedBy;
	}
	public void setModifiedBy(String modifiedBy) {
		this.modifiedBy = modifiedBy;
	}
    
}