package com.cdk.core.security.service;

import java.util.ArrayList;
import java.util.List;

/**
 * Authorities / Capabilities enum
 */
public enum Authority {

    REPMAN_CAPABILITIES(
            "View", "ViewAll", "Respond","FlagReview",
            "Moderate", "ThirdParty", "Admin",
            "ForcePublish", "MoveReview", "AccountSettings",
            "SocialMedia","SocialMediaAdmin");

    private List<String> capabilityList = new ArrayList<String>();

    Authority(String... capabilities) {
        for(String capability : capabilities) {
            capabilityList.add(capability);
        }
    }

    public List<String> getCapabilityList() {
        return capabilityList;
    }
}
