package com.cdk.core.security.service;

import com.cdk.core.security.dto.OAuthListTokenDto;
import com.cdk.core.security.dto.OAuthTokenDto;
import com.cdk.core.security.dto.OAuthValidateDto;

/**
 * read more @ https://confluence.cdk.com/display/DSCP/OAuth+Token+Management
 * 
 * APIs to generate, update, revoke and validate tokens
 * 
 * http://api-int.dit.adpedge.com/identityservice/1.1.1/rest/oauth/tokens/user/<>
 * 
 * @author Kevendra Patidar
 */
public interface IdentityService {
	
    public void deleteToken(String token);
    
    public OAuthTokenDto generateLongLivedToken(String username, String deviceId, String deviceType);
    
	public OAuthTokenDto generateSessionToken(final String username);
	
    public OAuthValidateDto validateToken(String token);
    
    public OAuthListTokenDto getAllTokens(String username);
        
}
