package com.cdk.core.security.dto;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;

/**
 * IAM OAuth List Token Response
 * 
{
  user={
    id=EDF212787743219FE0404064240C5106,
    userName=kevendra.patidar@cdk.com,
    firstName=null,
    lastName=null,
    accountStatus=null
  },
  tokens=[
    {
      tokenId=eba96ee4-ed59-4c3d-a871-13b6aa86e037,
      deviceId=163321035,
      deviceType=Android,
      comments=createdbyadmin,
      expirationTimestamp=2018-10-28T00: 00: 00-0700,
      createdBy=Admin,
      modifiedBy=Admin
    },
    . . .
    ]
}
 * 
 * @author Kevendra Patidar
 */
@JsonIgnoreProperties(ignoreUnknown = true)
public class OAuthListTokenDto {

	/* ************************************ Instance Fields ************************************ */
    private OAuthUserDto user;
    private List<OAuthTokenDto> tokens;
    
	/* ************************************ Public Methods ************************************ */
    @Override
	public String toString() {
		return "OAuthListTokenResponse [user=" + user + ", tokens=" + tokens
				+ "]";
	}

	/* ************************************ Getters and Setters ************************************ */
    public OAuthUserDto getUser() {
        return user;
    }
	public void setUser(OAuthUserDto user) {
        this.user = user;
    }
    public List<OAuthTokenDto> getTokens() {
        return tokens;
    }
    public void setTokens(List<OAuthTokenDto> tokens) {
        this.tokens = tokens;
    }
}
