package com.cdk.core.security.service.impl;

import java.io.IOException;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;

import javax.net.ssl.SSLContext;

import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.HttpClient;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;

/**
 * From http://www.baeldung.com/2012/04/16/how-to-use-resttemplate-with-basic-
 * authentication-in-spring-3-1/
 * 
 * http://stackoverflow.com/questions/23207928/how-to-use-resttemplate-with-basic-auth
 * 
 * <p>
 * And with that, everything is in place – the {@link RestTemplate} will now be
 * able to support the Basic Authentication scheme; a simple usage pattern would
 * be:
 * 
 * <pre>
 * final BasicRequestFactory requestFactory = new BasicRequestFactory(httpClient);
 * final RestTemplate restTemplate = new RestTemplate(requestFactory);
 * </pre>
 * 
 * And the request:
 *
 * <pre>
 * restTemplate.get(&quot;http://localhost:8080/spring/api/foos/1&quot;, Foo.class);
 * </pre>
 * 
 * @author Kevendra Patidar
 */
public class BasicRequestFactory extends HttpComponentsClientHttpRequestFactory {

	/* ************************************ Constructors ************************************ */
	public BasicRequestFactory(HttpClient httpClient) {
	    super(httpClient);
	}

	/* ************************************ Public Methods ************************************ */
	public static RestTemplate createTemplate() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
	    RestTemplate template = new RestTemplate(new BasicRequestFactory(createSecureClient()));
	    template.setErrorHandler(new NopResponseErrorHandler());
	    return template;
	}
	//TODO test createTemplate and createBasicAuthTemplate and delete or modify if not working
	public static RestTemplate createTemplate(String username, String password) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
	    RestTemplate template = new RestTemplate(new BasicRequestFactory(createSecureClient(username, password)));
	    template.setErrorHandler(new NopResponseErrorHandler());
	    return template;
	}
	public static RestTemplate createBasicAuthTemplate(String username, String password) {
	    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
	    credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(username, password));
	    HttpClient httpClient = HttpClientBuilder.create()
	            .setDefaultCredentialsProvider(credentialsProvider)
	            .build();

	    ClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory(httpClient);
	    RestTemplate template = new RestTemplate(requestFactory);

	    return template;
	}
	public static List<HttpMessageConverter<?>> getJaxbMessageConverters() {
        List<HttpMessageConverter<?>> converters = new ArrayList<HttpMessageConverter<?>>();
        converters.add(new Jaxb2RootElementHttpMessageConverter());
        //converters.add(new MappingJackson2HttpMessageConverter());
        //converters.add(new StringHttpMessageConverter());
        return converters;
    }       
	public static List<HttpMessageConverter<?>> getJsonMessageConverters() {
      MappingJackson2HttpMessageConverter jsonConverter = new MappingJackson2HttpMessageConverter();
      ObjectMapper objectMapper = jsonConverter.getObjectMapper();
      objectMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
//      SimpleDateFormat utcDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");
//      objectMapper.setDateFormat(utcDateFormat);
//      objectMapper.setSerializationInclusion(JsonInclude.Include.ALWAYS);
      List<HttpMessageConverter<?>> converters = new ArrayList<HttpMessageConverter<?>>();
      converters.add(jsonConverter);
      return converters;
    }	
	/*
	 * backup
	public HttpContext getHttpContext(HttpMethod httpMethod, URI uri, final String userName, final String password) {
		HttpClientContext localcontext = createHttpContext(httpMethod, uri);
		if (userName != null) {
			BasicCredentialsProvider credsProvider = new BasicCredentialsProvider();
			credsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(userName, password));
			localcontext.setCredentialsProvider(credsProvider);
		}
		return localcontext;
	}
	*/	
	@Override
	public HttpClientContext createHttpContext(HttpMethod httpMethod, URI uri){
		HttpHost targetHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
		// Generate BASIC scheme object and add it to the local auth cache
		BasicScheme basicAuth = new BasicScheme();

		// Create AuthCache instance
		AuthCache authCache = new BasicAuthCache();
		authCache.put(targetHost, basicAuth);

		// Add AuthCache to the execution context
		HttpClientContext localcontext = HttpClientContext.create();
		localcontext.setAuthCache(authCache);
	    //BasicHttpContext localContext = new BasicHttpContext();
	    //localContext.setAttribute(ClientContext.AUTH_CACHE, authCache);
	    return localcontext;
	}
	
	
	/* ************************************ Private Methods ************************************ */
	private static HttpClient createSecureClient() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
	    return getHttpClientBuilder().build();
	}
	private static HttpClient createSecureClient(String username, String password) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
	    BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
	    credentialsProvider.setCredentials(AuthScope.ANY, new UsernamePasswordCredentials(username, password));
	    return getHttpClientBuilder().setDefaultCredentialsProvider(credentialsProvider).build();
	}
	private static HttpClientBuilder getHttpClientBuilder() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
	    SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, new TrustSelfSignedStrategy()).useTLS().build();
	    SSLConnectionSocketFactory connectionFactory = new SSLConnectionSocketFactory(sslContext, new AllowAllHostnameVerifier());
	    return HttpClientBuilder.create().setSSLSocketFactory(connectionFactory);		
	}
	private static class NopResponseErrorHandler implements ResponseErrorHandler {
	    @Override
	    public boolean hasError(ClientHttpResponse chr) throws IOException {
	        return false;
	    }
	    @Override
	    public void handleError(ClientHttpResponse chr) throws IOException {
	    }
	}	

}
