package com.cdk.core.security.service.impl;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import me.parakh.core.model.converter.ModelMapper;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

import com.cdk.core.security.dto.UserCdkDto;
import com.cdk.core.security.service.Authority;
import com.cdk.core.security.service.CobaltUserService;
import com.cobaltgroup.services.user.api.UserService;
import com.cobaltgroup.services.user.dto.Capability;
import com.cobaltgroup.services.user.dto.GetAccessibleSecurablesRequest;
import com.cobaltgroup.services.user.dto.GetAccessibleSecurablesResponse;
import com.cobaltgroup.services.user.dto.GetAuthorizationRequest;
import com.cobaltgroup.services.user.dto.GetAuthorizationResponse;
import com.cobaltgroup.services.user.dto.GetUserDetailsRequest;
import com.cobaltgroup.services.user.dto.GetUserDetailsResponse;
import com.cobaltgroup.services.user.dto.Securable;
import com.cobaltgroup.services.user.dto.User;
import com.cobaltgroup.services.user.exception.ServiceException;

/**
 * org.springframework.remoting.httpinvoker.HttpComponentsHttpInvokerRequestExecutor
 * vs
 * org.springframework.remoting.httpinvoker.CommonsHttpInvokerRequestExecutor
 * 
 * @author Kevendra Patidar
 */
@Service
public class CobaltUserServiceImpl implements CobaltUserService {


	/* ************************************ Static Fields ************************************ */
    private static Logger LOG = LoggerFactory.getLogger(CobaltUserServiceImpl.class);
	public static final String REPMGT_SECURABLE_TYPE = "RepMgtDashboard";
	public static final String REPMGT_DEALER_SECURABLE_TYPE = "RepMgmtDealerDashboard";
    public static final List<String> SECURABLE_TYPES = Arrays.asList(REPMGT_SECURABLE_TYPE, REPMGT_DEALER_SECURABLE_TYPE);
    
	/* ************************************ Instance Fields ************************************ */    
    @Resource
    private UserService cdkUserService;/* @see application-context-user-remoting-service.xml */
	@Resource
	protected ModelMapper modelMapper;

	/* ************************************ Public Methods ************************************ */
    @Override
	public String test(){
    	return cdkUserService.helloWorld();
    }
    /**
     * Populate user object
     */
    @Override
	public UserCdkDto getUser(String username) {
        GetUserDetailsRequest request = new GetUserDetailsRequest();
        GetUserDetailsResponse response = null;
        request.setUsername(username);
        try {
			response = cdkUserService.getUserDetails(request);
		} catch (ServiceException e) {
			e.printStackTrace();
		}
        if(null != response){
        	User user = response.getUser();
        	return modelMapper.map(user, UserCdkDto.class);
        }
        return null;
    }
    /**
     * Populate Securables and Capability information for the User from User service
     */
    @Override
	public Map<String, List<String>> populateSecurables(final String userName, final List<String> securableTypes) {
    	try {
			GetAccessibleSecurablesResponse securablesResponse = getAccessibleSecurablesResponse(userName, securableTypes);
			Map<String, List<String>> dealerAuthorities = new HashMap<String, List<String>>();
			String webId;
			for(Securable securable : securablesResponse.getSecurables()) {
				LOG.debug("WebId:{}, Type:{}, ID:{}, Product:{}", securable.getWebId(), securable.getSecurableType(), securable.getSecurableItemId(), securable.getDetails());
			    GetAuthorizationRequest authReq = getGetAuthorizationRequest(userName, securable);
			    List<String> authorities = getAuthorities(authReq);
			    webId = securable.getWebId();
			    //addDealerAuthorities(dealerAuthorities, authorities, securable, securablesTypes);
			    dealerAuthorities.put(webId, authorities);
			}
		} catch (ServiceException e) {
			e.printStackTrace();
		}
    	return null;
    }
	/* ************************************ Private Methods ************************************ */

    private GetAccessibleSecurablesResponse getAccessibleSecurablesResponse(String username, List<String> securableTypes) throws ServiceException{
		GetAccessibleSecurablesRequest securablesRequest = new GetAccessibleSecurablesRequest();
		securablesRequest.setUsername(username);
        if(CollectionUtils.isEmpty(securableTypes)) {
            securablesRequest.setSecurableTypes(SECURABLE_TYPES);
        } else {
            securablesRequest.setSecurableTypes(securableTypes);
        }
        GetAccessibleSecurablesResponse securablesResponse = null;
        try {
            securablesResponse = cdkUserService.getAccessibleSecurables(securablesRequest);
        } catch (Exception e) {
            LOG.error("Exception getting securables from user service for username={}", username, e);
        }
		return securablesResponse;
	}    
	private GetAuthorizationRequest getGetAuthorizationRequest(final String userName, Securable securable) {
		GetAuthorizationRequest authRequest = new GetAuthorizationRequest();
		authRequest.setUsername(userName);
		authRequest.setSecurableItemId(securable.getSecurableItemId());
		authRequest.setCapabilities(Authority.REPMAN_CAPABILITIES.getCapabilityList());//FIXME
		return authRequest;
	}
	private List<String> getAuthorities(GetAuthorizationRequest authReq) throws ServiceException {
		GetAuthorizationResponse authResponse = cdkUserService.getAuthorization(authReq);
		List<String> authorities = new ArrayList<>();
		for(Capability capability : authResponse.getAuthorizedCapabilities()) {
			LOG.debug("Capability - Name:{}, Type:{}, Desc:{}", capability.getName(), capability.getSecurableType(), capability.getDescription());
			authorities.add(capability.getName());
		}
		return authorities;
	}
/*
	private void addDealerAuthorities(Map<String, Dealer> dealerAuthorities, List<String> authorities, Securable securable, List<String> securableTypes) {
		Dealer dealer = new Dealer();
		String webId = securable.getWebId();
		SocialEntityFilterCriteria criteria = new SocialEntityFilterCriteria();
		SocialEntity entity;
		criteria.setEntityType(EntityType.SITE);

		if(webId != null) {
			criteria.setEntityCode(webId);
			entity = entitySearchRestService.find(criteria);
		} else {
			entity = getRandomEntity();
			webId = entity.getEntityCode();
		}
		if(entity != null) {
			dealer.setName(entity.getName());
			dealer.setAuthorities(authorities);
            dealer.setOemProgramStatus(entity.getOemProgramStatus());
			dealerAuthorities.put(webId, dealer);
		} else if(securableTypes != null) {
            DealerInfo dealerInfo = localDealerInfoService.getDealerInfo(webId);
            if(dealerInfo != null) {
                dealer.setName(dealerInfo.getName());
                dealerAuthorities.put(webId, dealer);
            }
		} else {
            LOGGER.warn("WebId does not exist in Social ={}", webId);
        }
	}
 */
}
