/*
 * Decompiled with CFR 0.152.
 */
package com.cdk.core.security.service.impl;

import com.cdk.core.security.dto.OAuthTokenDto;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

public class AuthUtility {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthUtility.class);

    public static OAuthTokenDto existingTokens(String deviceId, String deviceType, List<OAuthTokenDto> existingTokens) {
        if (!CollectionUtils.isEmpty(existingTokens)) {
            for (OAuthTokenDto existingToken : existingTokens) {
                if (!AuthUtility.validToken(existingToken, deviceId, deviceType)) continue;
                LOGGER.debug("Valid token exist for user with token id as {} so returning existing token", (Object)existingToken.getTokenId());
                return existingToken;
            }
        }
        return null;
    }

    private static boolean isTokenAlive(Date expirationTimestamp) {
        Calendar cal = Calendar.getInstance();
        return cal.getTime().before(expirationTimestamp);
    }

    private static boolean validToken(OAuthTokenDto existingToken, String deviceId, String deviceType) {
        Date expirationTimestamp = existingToken.getExpirationTimestamp();
        boolean isTokenValid = false;
        if (null != expirationTimestamp && AuthUtility.isTokenAlive(expirationTimestamp)) {
            isTokenValid = deviceType.equalsIgnoreCase(existingToken.getDeviceType()) && deviceId.equalsIgnoreCase(existingToken.getDeviceId());
        }
        return isTokenValid;
    }
}

