/*
 * Decompiled with CFR 0.152.
 */
package com.cdk.core.security.service.impl;

import com.cdk.core.security.dto.OAuthListTokenDto;
import com.cdk.core.security.dto.OAuthTokenDto;
import com.cdk.core.security.dto.OAuthValidateDto;
import com.cdk.core.security.dto.UserCredentialDto;
import com.cdk.core.security.service.AuthTestType;
import com.cdk.core.security.service.AuthenticationServiceProvider;
import com.cdk.core.security.service.impl.AuthUtility;
import com.cdk.core.security.service.impl.IdentityServiceImpl;
import com.cdk.core.security.service.impl.SiteminderServiceImpl;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AuthenticationServiceProviderImpl
implements AuthenticationServiceProvider {
    private static Logger LOG = LoggerFactory.getLogger(AuthenticationServiceProviderImpl.class);
    @Resource
    private SiteminderServiceImpl siteminderService;
    @Resource
    private IdentityServiceImpl identityService;
    @Value(value="${useCdkIdentityService:false}")
    private boolean useCdkIdentityService;

    public Map<String, Object> test(AuthTestType type, String token, String username, String deviceId, String deviceType) {
        HashMap<String, Object> data = new HashMap<String, Object>();
        switch (type) {
            case validateToken: {
                OAuthValidateDto oauthValidateResponseV = this.identityService.validateToken(token);
                data.put("oauthTokenRequest", oauthValidateResponseV);
                break;
            }
            case deleteToken: {
                this.identityService.deleteToken(token);
                break;
            }
            case listToken: {
                OAuthListTokenDto oauthListTokenResponse = this.identityService.getAllTokens(username);
                data.put("oauthListTokenResponse", oauthListTokenResponse);
                break;
            }
            case generateLongLivedToken: {
                OAuthTokenDto oauthTokenRequest = this.identityService.generateLongLivedToken(username, deviceId, deviceType);
                data.put("oauthTokenRequest", oauthTokenRequest);
                break;
            }
            case generateSessionToken: {
                OAuthTokenDto oauthTokenRequestX = this.identityService.generateSessionToken(username);
                data.put("oauthTokenRequestX", oauthTokenRequestX);
            }
        }
        return data;
    }

    public OAuthTokenDto getToken(UserCredentialDto userCredentials, boolean genSortLivedToken) {
        this.updateDefaultIfEmpty(userCredentials);
        OAuthTokenDto oAuthTokenDto = this.createUserDto(userCredentials, genSortLivedToken, genSortLivedToken);
        return oAuthTokenDto;
    }

    private OAuthTokenDto createUserDto(UserCredentialDto userCredential, boolean isAuthenticated, boolean isSessionToken) {
        String userName = userCredential.getUsername();
        OAuthTokenDto oauthToken = null;
        if (!isAuthenticated) {
            OAuthListTokenDto oAuthListTokenResponse = this.siteminderService.authenticate(userCredential);
            if (null == oAuthListTokenResponse) {
                return null;
            }
            List existingTokens = oAuthListTokenResponse.getTokens();
            oauthToken = AuthUtility.existingTokens(userCredential.getDeviceId(), userCredential.getDeviceType(), existingTokens);
            if (null != oauthToken) {
                return oauthToken;
            }
        } else {
            LOG.error("FIXME ");
        }
        if (this.useCdkIdentityService) {
            oauthToken = isSessionToken ? this.identityService.generateSessionToken(userName) : this.identityService.generateLongLivedToken(userName, userCredential.getDeviceId(), userCredential.getDeviceType());
        }
        return oauthToken;
    }

    private String getDeviceType(String deviceType) {
        if (deviceType.length() > 10) {
            return deviceType.substring(0, 9);
        }
        return deviceType;
    }

    private void updateDefaultIfEmpty(UserCredentialDto userCredentials) {
        String deviceId = userCredentials.getDeviceId();
        String deviceType = userCredentials.getDeviceType();
        if (StringUtils.isEmpty((Object)deviceId)) {
            deviceId = this.getSecureRandom() + "";
        }
        if (StringUtils.isEmpty((Object)deviceType)) {
            LOG.debug("No deviceType provided");
            deviceType = "N/A";
        } else {
            deviceType = this.getDeviceType(deviceType);
        }
        userCredentials.setDeviceId(deviceId);
        userCredentials.setDeviceType(deviceType);
    }

    private int getSecureRandom() {
        try {
            SecureRandom secureRandomGenerator = SecureRandom.getInstance("SHA1PRNG");
            byte[] randomBytes = new byte[128];
            secureRandomGenerator.nextBytes(randomBytes);
            int seedByteCount = 5;
            byte[] seed = secureRandomGenerator.generateSeed(seedByteCount);
            SecureRandom secureRandom1 = SecureRandom.getInstance("SHA1PRNG");
            secureRandom1.setSeed(seed);
            return secureRandom1.nextInt();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return 0;
        }
    }
}

