package com.cobalt.framework.security.httpinvoker;

import java.io.IOException;

import javax.annotation.PostConstruct;

import org.apache.commons.codec.binary.Base64;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpPost;
import org.springframework.remoting.httpinvoker.HttpComponentsHttpInvokerRequestExecutor;
import org.springframework.remoting.httpinvoker.HttpInvokerClientConfiguration;

/**
 * 
 * @see com.cobalt.framework.security.httpinvoker.BasicAuthCommonsHttpInvokerRequestExecutor
 * 
 * @author Kevendra Patidar
 */
public class BasicAuthHttpComponentsHttpInvokerRequestExecutor extends HttpComponentsHttpInvokerRequestExecutor {

	/* ************************************ Instance Fields ************************************ */    
	private String username;
    private String password;
    RequestConfig requestConfig;
    
	/* ************************************ Constructors ************************************ */
	@PostConstruct
	public void initIt() throws Exception {
    	//requestConfig = RequestConfig.custom().setCookieSpec(CookieSpecs.IGNORE_COOKIES).build();
    	//System.out.println("requestConfig " +requestConfig.toString());
		//getHttpClient().getParams().setParameter(ClientPNames.COOKIE_POLICY, CookiePolicy.IGNORE_COOKIES);
	}
	
	/* ************************************ Public Methods ************************************ */
    @Override
	protected HttpPost createHttpPost(HttpInvokerClientConfiguration config) throws IOException {
    	        
        HttpPost post = super.createHttpPost(config);
        final String base64 = username + ':' + password;
        post.setHeader("Authorization", "Basic " + new String(Base64.encodeBase64(base64.getBytes())));
        return post;
    }

	/* ************************************ Getters and Setters ************************************ */
	public void setUsername(String username) {
		this.username = username;
	}
	public void setPassword(String password) {
		this.password = password;
		
	}
    
}
