package com.cdk.core.security.service.impl;

import java.util.Calendar;
import java.util.Date;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.CollectionUtils;

import com.cdk.core.security.dto.OAuthTokenDto;

/**
 * 
 * @author Kevendra Patidar
 */
public class AuthUtility {

	/* ************************************ Static Fields ************************************ */
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthUtility.class);
    
	/* ************************************ Public Methods ************************************ */
    public static OAuthTokenDto existingTokens(String deviceId, String deviceType, List<OAuthTokenDto> existingTokens){
        if(! CollectionUtils.isEmpty(existingTokens)){
            for(OAuthTokenDto existingToken: existingTokens){
        		if(validToken(existingToken, deviceId, deviceType)){
        			LOGGER.debug("Valid token exist for user with token id as {} so returning existing token", existingToken.getTokenId());
        			return existingToken;
        		}
        	}
            /* return first element if nothing is match
             * siteminder does not create new Long Lived Token for a different device(deviceId/deviceType) 
             * if a valid Long Lived Token already created 
             * TODO need some more testing
             */ 
            //return returnBestMetch(existingTokens);
        }
        return null;
    }
    
	/* ************************************ Private Methods ************************************ */
    /*
	private static OAuthTokenDto returnBestMetch(List<OAuthTokenDto> existingTokens) {
		for(OAuthTokenDto existingToken: existingTokens){
			if(validLongLivedToken(existingToken)){
				return existingToken;
			}
		}
		return existingTokens.get(0);
	}
    private static boolean validLongLivedToken(OAuthTokenDto existingToken) {
    	Date expirationTimestamp = existingToken.getExpirationTimestamp();
		return (null != expirationTimestamp 
				&& isTokenAlive(expirationTimestamp)
				&& "Long Lived Token".equalsIgnoreCase(existingToken.getComments()));
	}
*/
	/**
     * @return true - for future expirationTimestamp time
     */
	private static boolean isTokenAlive(Date expirationTimestamp) {
		Calendar cal = Calendar.getInstance();
		return cal.getTime().before(expirationTimestamp);
	}
    /**
     * FIXME deviceId should be given higher precedence 
     */
    private static boolean validToken(OAuthTokenDto existingToken, String deviceId, String deviceType) {
    	Date expirationTimestamp = existingToken.getExpirationTimestamp();
		boolean isTokenValid = false;
    	if(null != expirationTimestamp && isTokenAlive(expirationTimestamp)){
    		isTokenValid = (deviceType.equalsIgnoreCase(existingToken.getDeviceType()) &&
    				deviceId.equalsIgnoreCase(existingToken.getDeviceId()) );
    	}
		return isTokenValid;
	}    
}
