package com.cdk.core.security.service.impl;

import java.nio.charset.Charset;

import javax.annotation.PostConstruct;

import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

import com.cdk.core.security.dto.OAuthListTokenDto;
import com.cdk.core.security.dto.UserCredentialDto;
import com.cdk.core.security.service.SiteminderService;

/**
 * Class for authentication against siteminder Service
 * 
 * @author Kevendra Patidar
 */
@Service
public class SiteminderServiceImpl implements SiteminderService {

	/* ************************************ Static Fields ************************************ */
    private static Logger LOG = LoggerFactory.getLogger(SiteminderServiceImpl.class);
    
	/* ************************************ Instance Fields ************************************ */
    @Value("${auth.server.url:https://login-dit.adpedge.com}")	//"https://login.adpedge.com  https://login-dit.adpedge.com
    private String authUrl;
    private RestTemplate restTemplate;

	/* ************************************ Public Methods ************************************ */
    @PostConstruct
    public void registerConverters(){
    	restTemplate = new RestTemplate();
        restTemplate.setMessageConverters(BasicRequestFactory.getJsonMessageConverters());
    }
    
    /**
     * Call IAM identity Service to authenticate the user
     * different implementation throws AuthenticationException
     */
    public OAuthListTokenDto authenticate(UserCredentialDto user) {
    	String username = user.getUsername();
    	String password = user.getPassword();
        Assert.notNull("Username cannot be null for authentication", username);
        Assert.notNull("Password cannot be null for authentication", password);
        LOG.debug("User with username= {} is requesting authentication", username);
        //Now call siteminder
        return authenticate(username, password);
    }
    
	/* ************************************ Private Methods ************************************ */
    /**
     * Call siteminder for authentication
     */
    private OAuthListTokenDto authenticate(String username, String password) {
    	String url = authUrl + "/oauth/gettokens";
        try{
            //Create request entity
            HttpEntity<?> requestEntity = getRequest(username, password);  
            ResponseEntity<OAuthListTokenDto> responseEntity =  restTemplate.exchange(url, HttpMethod.GET, requestEntity, OAuthListTokenDto.class);
            if(null != responseEntity && null != responseEntity.getBody()) {
                LOG.debug("User successfully authenticated against siteminder for id= {} response={}", username, responseEntity.getBody());
                OAuthListTokenDto authListTokenDto = responseEntity.getBody();
                return authListTokenDto;
            }
        } catch (RestClientException exception) {
            LOG.warn("Siteminder call failed to authenticate for id= {} and url= {} and error= {}", username, url, exception.getMessage());
            if(exception instanceof HttpClientErrorException) {
                HttpClientErrorException clientErrorException = (HttpClientErrorException) exception;
                HttpStatus status = clientErrorException.getStatusCode();
                LOG.debug("HttpStatus {}", status);//exception.getMessage() contain 401 but status contain value of 400
                /*
                if(status != null && status.equals("401")) {
                	throw new AuthenticationServiceException("Wrong username or password for id= " +username+" with error= "+ exception.getMessage());
                }
                */
            } else {
                /*
                 throw new AuthenticationServiceException("Siteminder call failed to authenticate for id= " +username+" with error= "+ exception.getMessage());
                 */
            }
        } catch (Exception exception) {
            LOG.warn("Siteminder call failed with generic exception for id= {} with url= {} and error={}", username, url, exception.getMessage());
            /*
             throw new AuthenticationServiceException("Siteminder call failed with generic exception for id= " + username+ " with error= "+ exception.getMessage());
             */
        } finally {
        	/*
            //Clear the cookies
            //httpClient.getCookieStore().clear();
             */
        }
        /*
		 throw new AuthenticationServiceException("Authentication Failed for userId= " +username);
         */
        return null;
    }

    /**
     * Create request body to call siteminder
     */
    private HttpEntity<?> getRequest(String username, String password) {
        HttpHeaders headers = getHttpHeaders(username, password);
        HttpEntity<?> requestEntity = new HttpEntity<MultiValueMap<String, String>>(null, headers);
        return requestEntity;
    }
    private HttpHeaders getHttpHeaders(String username, String password) {
        String auth = username+":"+password;//plainCreds
        byte[] encodedAuth = Base64.encodeBase64(auth.getBytes(Charset.forName("US-ASCII")));//base64CredsBytes
        String authHeader = "Basic " + new String(encodedAuth);//base64Creds
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setCacheControl("max-age=0, no-cache, no-store");
        headers.setPragma("no-cache");
        headers.add("Authorization", authHeader);
        return headers;
    }
    
}
