/*
 * Decompiled with CFR 0.152.
 */
package com.cdk.core.security.service.impl;

import com.cdk.core.security.dto.OAuthListTokenDto;
import com.cdk.core.security.dto.UserCredentialDto;
import com.cdk.core.security.service.SiteminderService;
import com.cdk.core.security.service.impl.BasicRequestFactory;
import java.nio.charset.Charset;
import javax.annotation.PostConstruct;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpClientErrorException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class SiteminderServiceImpl
implements SiteminderService {
    private static Logger LOG = LoggerFactory.getLogger(SiteminderServiceImpl.class);
    @Value(value="${auth.server.url:https://login-dit.adpedge.com}")
    private String authUrl;
    private RestTemplate restTemplate;

    @PostConstruct
    public void registerConverters() {
        this.restTemplate = new RestTemplate();
        this.restTemplate.setMessageConverters(BasicRequestFactory.getJsonMessageConverters());
    }

    public OAuthListTokenDto authenticate(UserCredentialDto user) {
        String username = user.getUsername();
        String password = user.getPassword();
        Assert.notNull((Object)"Username cannot be null for authentication", (String)username);
        Assert.notNull((Object)"Password cannot be null for authentication", (String)password);
        LOG.debug("User with username= {} is requesting authentication", (Object)username);
        return this.authenticate(username, password);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private OAuthListTokenDto authenticate(String username, String password) {
        String url = this.authUrl + "/oauth/gettokens";
        try {
            HttpEntity<?> requestEntity = this.getRequest(username, password);
            ResponseEntity responseEntity = this.restTemplate.exchange(url, HttpMethod.GET, requestEntity, OAuthListTokenDto.class, new Object[0]);
            if (null == responseEntity) return null;
            if (null == responseEntity.getBody()) return null;
            LOG.debug("User successfully authenticated against siteminder for id= {} response={}", (Object)username, responseEntity.getBody());
            OAuthListTokenDto authListTokenDto = (OAuthListTokenDto)responseEntity.getBody();
            return authListTokenDto;
        }
        catch (RestClientException exception) {
            LOG.warn("Siteminder call failed to authenticate for id= {} and url= {} and error= {}", new Object[]{username, url, exception.getMessage()});
            if (!(exception instanceof HttpClientErrorException)) return null;
            HttpClientErrorException clientErrorException = (HttpClientErrorException)exception;
            HttpStatus status = clientErrorException.getStatusCode();
            LOG.debug("HttpStatus {}", (Object)status);
            return null;
        }
        catch (Exception exception) {
            LOG.warn("Siteminder call failed with generic exception for id= {} with url= {} and error={}", new Object[]{username, url, exception.getMessage()});
            return null;
        }
    }

    private HttpEntity<?> getRequest(String username, String password) {
        HttpHeaders headers = this.getHttpHeaders(username, password);
        HttpEntity requestEntity = new HttpEntity(null, (MultiValueMap)headers);
        return requestEntity;
    }

    private HttpHeaders getHttpHeaders(String username, String password) {
        String auth = username + ":" + password;
        byte[] encodedAuth = Base64.encodeBase64((byte[])auth.getBytes(Charset.forName("US-ASCII")));
        String authHeader = "Basic " + new String(encodedAuth);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_JSON);
        headers.setCacheControl("max-age=0, no-cache, no-store");
        headers.setPragma("no-cache");
        headers.add("Authorization", authHeader);
        return headers;
    }
}

