/*
 * Decompiled with CFR 0.152.
 */
package com.cdk.core.security.api;

import com.cdk.core.security.dto.OAuthValidateDto;
import com.cdk.core.security.service.impl.IdentityServiceImpl;
import com.cdk.core.security.service.impl.SiteminderServiceImpl;
import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.ModelAndView;

@Component
public class OauthTokenValidationInterceptor
implements HandlerInterceptor {
    private static final Logger LOG = LoggerFactory.getLogger(OauthTokenValidationInterceptor.class);
    private static final String SECURITY_TOKEN_HEADER = "x-access-token";
    @Resource
    private SiteminderServiceImpl siteminderService;
    @Resource
    private IdentityServiceImpl identityService;

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String accessToken = request.getHeader(SECURITY_TOKEN_HEADER);
        LOG.info("Access token {}", (Object)accessToken);
        if (StringUtils.isEmpty((Object)accessToken)) {
            LOG.error("Access token is null for a request to {}", (Object)request.getRequestURL());
            String url = request.getRequestURL().toString();
            if ("".equals(url)) {
                return true;
            }
            return this.unauthorizedRequest(response);
        }
        return this.checkToken(request, response);
    }

    private boolean checkToken(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String accessToken = request.getHeader(SECURITY_TOKEN_HEADER);
        try {
            OAuthValidateDto authValidateDto = this.identityService.validateToken(accessToken);
            if (null != authValidateDto && "Success".equalsIgnoreCase(authValidateDto.getStatus())) {
                return true;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        LOG.debug("Access token is invalid {}", (Object)accessToken);
        return this.unauthorizedRequest(response);
    }

    private boolean unauthorizedRequest(HttpServletResponse response) throws IOException {
        response.sendError(401);
        return false;
    }

    public void postHandle(HttpServletRequest request, HttpServletResponse response, Object handler, ModelAndView modelAndView) throws Exception {
    }

    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, Exception ex) throws Exception {
    }
}

