/*
 * Decompiled with CFR 0.152.
 */
package com.cdk.core.security.service.impl;

import com.cdk.core.security.dto.UserCdkDto;
import com.cdk.core.security.service.Authority;
import com.cdk.core.security.service.CobaltUserService;
import com.cobaltgroup.services.user.api.UserService;
import com.cobaltgroup.services.user.dto.Capability;
import com.cobaltgroup.services.user.dto.GetAccessibleSecurablesRequest;
import com.cobaltgroup.services.user.dto.GetAccessibleSecurablesResponse;
import com.cobaltgroup.services.user.dto.GetAuthorizationRequest;
import com.cobaltgroup.services.user.dto.GetAuthorizationResponse;
import com.cobaltgroup.services.user.dto.GetUserDetailsRequest;
import com.cobaltgroup.services.user.dto.GetUserDetailsResponse;
import com.cobaltgroup.services.user.dto.Securable;
import com.cobaltgroup.services.user.dto.User;
import com.cobaltgroup.services.user.exception.ServiceException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import me.parakh.core.model.converter.ModelMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class CobaltUserServiceImpl
implements CobaltUserService {
    private static Logger LOG = LoggerFactory.getLogger(CobaltUserServiceImpl.class);
    public static final String REPMGT_SECURABLE_TYPE = "RepMgtDashboard";
    public static final String REPMGT_DEALER_SECURABLE_TYPE = "RepMgmtDealerDashboard";
    public static final List<String> SECURABLE_TYPES = Arrays.asList("RepMgtDashboard", "RepMgmtDealerDashboard");
    @Resource
    private UserService cdkUserService;
    @Resource
    protected ModelMapper modelMapper;

    public String test() {
        return this.cdkUserService.helloWorld();
    }

    public UserCdkDto getUser(String username) {
        GetUserDetailsRequest request = new GetUserDetailsRequest();
        GetUserDetailsResponse response = null;
        request.setUsername(username);
        try {
            response = this.cdkUserService.getUserDetails(request);
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        if (null != response) {
            User user = response.getUser();
            return (UserCdkDto)this.modelMapper.map((Object)user, UserCdkDto.class);
        }
        return null;
    }

    public Map<String, List<String>> populateSecurables(String userName, List<String> securableTypes) {
        try {
            GetAccessibleSecurablesResponse securablesResponse = this.getAccessibleSecurablesResponse(userName, securableTypes);
            HashMap<String, List<String>> dealerAuthorities = new HashMap<String, List<String>>();
            for (Securable securable : securablesResponse.getSecurables()) {
                LOG.debug("WebId:{}, Type:{}, ID:{}, Product:{}", new Object[]{securable.getWebId(), securable.getSecurableType(), securable.getSecurableItemId(), securable.getDetails()});
                GetAuthorizationRequest authReq = this.getGetAuthorizationRequest(userName, securable);
                List<String> authorities = this.getAuthorities(authReq);
                String webId = securable.getWebId();
                dealerAuthorities.put(webId, authorities);
            }
        }
        catch (ServiceException e) {
            e.printStackTrace();
        }
        return null;
    }

    private GetAccessibleSecurablesResponse getAccessibleSecurablesResponse(String username, List<String> securableTypes) throws ServiceException {
        GetAccessibleSecurablesRequest securablesRequest = new GetAccessibleSecurablesRequest();
        securablesRequest.setUsername(username);
        if (CollectionUtils.isEmpty(securableTypes)) {
            securablesRequest.setSecurableTypes(SECURABLE_TYPES);
        } else {
            securablesRequest.setSecurableTypes(securableTypes);
        }
        GetAccessibleSecurablesResponse securablesResponse = null;
        try {
            securablesResponse = this.cdkUserService.getAccessibleSecurables(securablesRequest);
        }
        catch (Exception e) {
            LOG.error("Exception getting securables from user service for username={}", (Object)username, (Object)e);
        }
        return securablesResponse;
    }

    private GetAuthorizationRequest getGetAuthorizationRequest(String userName, Securable securable) {
        GetAuthorizationRequest authRequest = new GetAuthorizationRequest();
        authRequest.setUsername(userName);
        authRequest.setSecurableItemId(securable.getSecurableItemId());
        authRequest.setCapabilities(Authority.REPMAN_CAPABILITIES.getCapabilityList());
        return authRequest;
    }

    private List<String> getAuthorities(GetAuthorizationRequest authReq) throws ServiceException {
        GetAuthorizationResponse authResponse = this.cdkUserService.getAuthorization(authReq);
        ArrayList<String> authorities = new ArrayList<String>();
        for (Capability capability : authResponse.getAuthorizedCapabilities()) {
            LOG.debug("Capability - Name:{}, Type:{}, Desc:{}", new Object[]{capability.getName(), capability.getSecurableType(), capability.getDescription()});
            authorities.add(capability.getName());
        }
        return authorities;
    }
}

