/*
 * Decompiled with CFR 0.152.
 */
package com.cdk.core.security.service.impl;

import com.cdk.core.security.dto.OAuthListTokenDto;
import com.cdk.core.security.dto.OAuthTokenDto;
import com.cdk.core.security.dto.OAuthValidateDto;
import com.cdk.core.security.service.IdentityService;
import com.cdk.core.security.service.impl.BasicRequestFactory;
import java.util.Arrays;
import me.parakh.core.model.util.DateUtility;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.MediaType;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class IdentityServiceImpl
implements IdentityService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IdentityServiceImpl.class);
    public static final String IAM_BASE_SERVICE = "/identityservice/1.1.1/rest/";
    public static final String IAM_USER_ENDPOINT = "/identityservice/1.1.1/rest/oauth/";
    public static final String IAM_ADMIN_ENDPOINT = "/identityservice/1.1.1/rest/admin/oauth/";
    public static final String IAM_USER_VALIDATE = "/identityservice/1.1.1/rest/oauth/validate/";
    public static final String IAM_USER_SESSION_TOKEN = "/identityservice/1.1.1/rest/oauth/session-token/";
    public static final String IAM_USER_TOKENS = "/identityservice/1.1.1/rest/oauth/tokens/user/";
    public static final String IAM_ADMIN_TOKENS = "/identityservice/1.1.1/rest/admin/oauth/tokens/user/";
    public static final String IAM_ADMIN_DELETE_TOKENS = "/identityservice/1.1.1/rest/admin/oauth/tokens/";
    @Value(value="${iam.service.user:dit-remote}")
    private String username;
    @Value(value="${iam.service.password:dit-remsleep}")
    private String password;
    @Value(value="${iam.service.url:http://api-int.dit.adpedge.com}")
    private String iamUrl;
    @Value(value="${token.expiry.days:45}")
    private Integer tokenExpiryDays;

    public void deleteToken(String token) {
        String url = this.iamUrl + IAM_ADMIN_DELETE_TOKENS + token;
        this.getRestTemplate().delete(url, new Object[0]);
    }

    public OAuthTokenDto generateLongLivedToken(String username, String deviceId, String deviceType) throws RestClientException {
        OAuthTokenDto tokenRequest = new OAuthTokenDto();
        tokenRequest.setDeviceId(deviceId);
        tokenRequest.setDeviceType(deviceType);
        tokenRequest.setComments("Long Lived Token - created by EDGE");
        tokenRequest.setExpirationTimestamp(DateUtility.addDays((int)this.tokenExpiryDays));
        String adminUrl = this.iamUrl + IAM_ADMIN_TOKENS + username;
        HttpHeaders headers = this.getHttpHeaders();
        HttpEntity entity = new HttpEntity((Object)tokenRequest, (MultiValueMap)headers);
        RestTemplate restTemplate = this.getRestTemplate();
        restTemplate.setMessageConverters(BasicRequestFactory.getJsonMessageConverters());
        LOGGER.debug("Creating long term token using IAM Service");
        return (OAuthTokenDto)restTemplate.postForObject(adminUrl, (Object)entity, OAuthTokenDto.class, new Object[0]);
    }

    public OAuthTokenDto generateSessionToken(String username) throws RestClientException {
        LOGGER.debug("Getting tokes from IAM Service");
        String url = this.iamUrl + IAM_USER_SESSION_TOKEN + username;
        HttpHeaders headers = this.getHttpHeaders();
        HttpEntity entity = new HttpEntity((Object)"parameters", (MultiValueMap)headers);
        return (OAuthTokenDto)this.getRestTemplate().postForObject(url, (Object)entity, OAuthTokenDto.class, new Object[0]);
    }

    public OAuthValidateDto validateToken(String token) {
        String url = this.iamUrl + IAM_USER_VALIDATE + token;
        RestTemplate restTemplate = this.getRestTemplate();
        restTemplate.setMessageConverters(BasicRequestFactory.getJaxbMessageConverters());
        return (OAuthValidateDto)restTemplate.getForObject(url, OAuthValidateDto.class, new Object[0]);
    }

    public OAuthListTokenDto getAllTokens(String username) throws RestClientException {
        String url = this.iamUrl + IAM_USER_TOKENS + username;
        return (OAuthListTokenDto)this.getRestTemplate().getForObject(url, OAuthListTokenDto.class, new Object[0]);
    }

    private HttpHeaders getHttpHeaders() {
        HttpHeaders headers = new HttpHeaders();
        headers.setAccept(Arrays.asList(MediaType.APPLICATION_JSON));
        headers.setContentType(MediaType.APPLICATION_JSON);
        return headers;
    }

    private RestTemplate getRestTemplate() {
        return BasicRequestFactory.createBasicAuthTemplate(this.username, this.password);
    }

    public RestTemplate createBasicAuthTemplate(String username, String password) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        RestTemplate template = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        return template;
    }
}

