/*
 * Decompiled with CFR 0.152.
 */
package com.cdk.core.security.service.impl;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.net.URI;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import org.apache.http.HttpHost;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.AuthCache;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpClient;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.conn.ssl.AllowAllHostnameVerifier;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLContexts;
import org.apache.http.conn.ssl.TrustSelfSignedStrategy;
import org.apache.http.conn.ssl.TrustStrategy;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.auth.BasicScheme;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.springframework.http.HttpMethod;
import org.springframework.http.client.ClientHttpRequestFactory;
import org.springframework.http.client.ClientHttpResponse;
import org.springframework.http.client.HttpComponentsClientHttpRequestFactory;
import org.springframework.http.converter.HttpMessageConverter;
import org.springframework.http.converter.json.MappingJackson2HttpMessageConverter;
import org.springframework.http.converter.xml.Jaxb2RootElementHttpMessageConverter;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class BasicRequestFactory
extends HttpComponentsClientHttpRequestFactory {
    public BasicRequestFactory(HttpClient httpClient) {
        super(httpClient);
    }

    public static RestTemplate createTemplate() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        RestTemplate template = new RestTemplate((ClientHttpRequestFactory)new BasicRequestFactory(BasicRequestFactory.createSecureClient()));
        template.setErrorHandler((ResponseErrorHandler)new NopResponseErrorHandler());
        return template;
    }

    public static RestTemplate createTemplate(String username, String password) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        RestTemplate template = new RestTemplate((ClientHttpRequestFactory)new BasicRequestFactory(BasicRequestFactory.createSecureClient(username, password)));
        template.setErrorHandler((ResponseErrorHandler)new NopResponseErrorHandler());
        return template;
    }

    public static RestTemplate createBasicAuthTemplate(String username, String password) {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        CloseableHttpClient httpClient = HttpClientBuilder.create().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
        HttpComponentsClientHttpRequestFactory requestFactory = new HttpComponentsClientHttpRequestFactory((HttpClient)httpClient);
        RestTemplate template = new RestTemplate((ClientHttpRequestFactory)requestFactory);
        return template;
    }

    public static List<HttpMessageConverter<?>> getJaxbMessageConverters() {
        ArrayList converters = new ArrayList();
        converters.add((HttpMessageConverter<?>)new Jaxb2RootElementHttpMessageConverter());
        return converters;
    }

    public static List<HttpMessageConverter<?>> getJsonMessageConverters() {
        MappingJackson2HttpMessageConverter jsonConverter = new MappingJackson2HttpMessageConverter();
        ObjectMapper objectMapper = jsonConverter.getObjectMapper();
        objectMapper.configure(SerializationFeature.WRAP_ROOT_VALUE, true);
        ArrayList converters = new ArrayList();
        converters.add((HttpMessageConverter<?>)jsonConverter);
        return converters;
    }

    public HttpClientContext createHttpContext(HttpMethod httpMethod, URI uri) {
        HttpHost targetHost = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
        BasicScheme basicAuth = new BasicScheme();
        BasicAuthCache authCache = new BasicAuthCache();
        authCache.put(targetHost, (AuthScheme)basicAuth);
        HttpClientContext localcontext = HttpClientContext.create();
        localcontext.setAuthCache((AuthCache)authCache);
        return localcontext;
    }

    private static HttpClient createSecureClient() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        return BasicRequestFactory.getHttpClientBuilder().build();
    }

    private static HttpClient createSecureClient(String username, String password) throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        BasicCredentialsProvider credentialsProvider = new BasicCredentialsProvider();
        credentialsProvider.setCredentials(AuthScope.ANY, (Credentials)new UsernamePasswordCredentials(username, password));
        return BasicRequestFactory.getHttpClientBuilder().setDefaultCredentialsProvider((CredentialsProvider)credentialsProvider).build();
    }

    private static HttpClientBuilder getHttpClientBuilder() throws NoSuchAlgorithmException, KeyStoreException, KeyManagementException {
        SSLContext sslContext = SSLContexts.custom().loadTrustMaterial(null, (TrustStrategy)new TrustSelfSignedStrategy()).useTLS().build();
        SSLConnectionSocketFactory connectionFactory = new SSLConnectionSocketFactory(sslContext, (X509HostnameVerifier)new AllowAllHostnameVerifier());
        return HttpClientBuilder.create().setSSLSocketFactory((LayeredConnectionSocketFactory)connectionFactory);
    }

    private static class NopResponseErrorHandler
    implements ResponseErrorHandler {
        private NopResponseErrorHandler() {
        }

        public boolean hasError(ClientHttpResponse chr) throws IOException {
            return false;
        }

        public void handleError(ClientHttpResponse chr) throws IOException {
        }
    }
}

