package me.parakh.core.dto.common;

import java.util.Date;

import me.parakh.core.model.type.MobilePlatform;

/**
 * device token from (push notification GCM vs APNs)
 *  
 * @author Kevendra Patidar
 */
public class TokenDto {

	/* ************************************ Instance Fields ************************************ */
	/* 
	 * fixed size like ionic provide to each app -OR- me.parakh.edu
	 * NOTE: appId require only if same server is used for multiple app 
	 */
	private String id;/* compound key = deviceId + SEPARATOR + appId (ionic app id) */
	private String token;
	private boolean active;
	private MobilePlatform os;

	private Date modified;
	private Date created;

	/* ************************************ Public Methods ************************************ */
	@Override
	public String toString() {
		return "TokenVo [id=" + id + ", token="
				+ token + ", active=" + active + ", os=" + os + ", modified="
				+ modified + ", created=" + created + "]";
	}

	/* ************************************ Getters and Setters ************************************ */
	public String getId() {
		return id;
	}
	public void setId(final String id) {
		this.id = id;
	}
	public String getToken() {
		return token;
	}
	public void setToken(String token) {
		this.token = token;
	}
	public boolean isActive() {
		return active;
	}
	public void setActive(final boolean active) {
		this.active = active;
	}
	public MobilePlatform getOs() {
		return os;
	}
	public void setOs(MobilePlatform os) {
		this.os = os;
	}
	public Date getModified() {
		return modified;
	}
	public void setModified(final Date modified) {
		this.modified = modified;
	}
	public Date getCreated() {
		return created;
	}
	public void setCreated(Date created) {
		this.created = created;
	}

}
