package me.parakh.core.model.converter;

import java.util.ArrayList;
import java.util.List;

import org.dozer.DozerBeanMapper;
import org.springframework.stereotype.Component;

/**
 * Dozer mapper implementation
 * - handles registering any override files that exist
 * - handles Collection -> mapping calls
 * - actual dozer library does the rest.
 * 
 * @author Kevendra Patidar
 */
@Component
public class DozerMapperImpl implements ModelMapper {
	
	/* ************************************ Instance Fields ************************************ */
    private DozerBeanMapper mapper = new DozerBeanMapper();

	/* ************************************ Public Methods ************************************ */
    @Override
    public <T> T map(Object source, Class<T> destination) {
        return mapper.map(source,destination);
    }
    @Override
    public <T> List<T> mapList(List<?> source, Class<T> destination) {
        List<T> retList = new ArrayList<T>(source.size());
        for(Object model: source){
            retList.add(map(model,destination));
        }
        return retList;
    }

}
