package me.parakh.core.model.converter;

import java.util.List;

/**
 * This class represents the interface into the ModelToDTO mapping
 * subsystem.
 *
 * We have a LOT of DTO classes. It would be a pain if we had to write
 * a mapper class for each and every one - this is an attempt to
 * make the problem easier to manage
 * 
 * @author Kevendra Patidar
 */
public interface ModelMapper {

    /**
     * Given a Model object and the DTO Class we expect to map to, create and populate
     * an
     * @param source The populated model object.
     * @param destination The DTO Class
     * @param <T> The type of class we expect. Allows us to type the response to match the input to reduce casting.
     * @return A populated DTO object
     */
    public <T> T map(Object source,Class<T> destination);

    /**
     * Composite helper method. wWould need to provide helpers for other collections possibly...
     */
    public <T> List<T> mapList(List<?> source, Class<T> destination);

}
