package me.parakh.core.model.util;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;

/**
 * JSON Parse Utility
 *
 * @author Kevendra Patidar
 */
public abstract class JsonUtility {
	
	/* ************************************ Static Fields ************************************ */
	private static final Logger LOG = LoggerFactory.getLogger(JsonUtility.class);

	/* ************************************ Public Methods ************************************ */
	/**
	 * Convert JSON to Java object
	 * @param json String
	 * @param Java object Type
	 * @return Java object
	 */
    public static <T> T toJava(String json, Class<T> valueType){
    	try{
    		return new ObjectMapper().readValue(json, valueType);
		}catch(Exception e){
			LOG.error("error during convert JSON String into Java object", e);
		}
    	return null;
    }
    /**
     * Convert Java object to JSON format
     * @see DealerCookie.getAsJSON()
     * @param valueType
     * @return
     */
    public static String toJson(Object value){
		try{
	    	return new ObjectMapper().writeValueAsString(value) ;
	    }catch(JsonProcessingException e){
	    	LOG.error("Json Processing Exception", e);
	    }catch(Exception e){
			LOG.error("error during convert Java object to JSON String ", e);
		}
    	return null;
    }

}
