package me.parakh.core.model.util;

import java.text.DecimalFormat;
import java.text.NumberFormat;

import org.springframework.util.StringUtils;

/**
 *
 * @author Kevendra Patidar
 */
public abstract class StringUtility {

	/* ************************************ Public Methods ************************************ */
	public static final String concatenate(final String ... strings){
		StringBuffer buffer = new StringBuffer();
		for(String s: strings){
			if(StringUtils.hasText(s)){
				buffer.append(" " +s.trim());
			}
		}
		return buffer.toString();
	}
	/**
	 * Use this method to normalize str for lookup
	 */
	public static String normalize(final String str) {
		if(StringUtils.isEmpty(str)){
			return str;
		}
		return str.toLowerCase();
	}
	public static final String getName(String fName, String mName, String lNmane){
		if(StringUtils.hasText(fName)){
			fName = " " +fName.trim();
		}else{
			fName = "";
		}
		if(StringUtils.hasText(mName)){
			mName = " " +mName.trim();
		}else{
			mName = "";
		}
		if(StringUtils.hasText(lNmane)){
			lNmane = " " +lNmane.trim();
		}else{
			lNmane = "";
		}
		return (fName+mName+lNmane).trim();
	}
	public static final String trim(final String s){
		if(null != s){
			return s.trim();
		}
		return s;
	}
	public static String replace0withNA(final int no){
		if(no == 0){
			return "-";
		}
		return no + "";
	}
	/**
	 * camelcase
	 * @param input xxxx Tests and AA  sSpad Come
	 * @return Xxxx Tests And Aa  Sspad Come
	 */
	public static String toTitleCase(final String input) {
		if(StringUtils.isEmpty(input)){
			return input;
		}
		StringBuffer titleCase = new StringBuffer();
		String[] tokens = input.split(" ");
		for (String i : tokens) {
			i = StringUtils.trimWhitespace(i);
			titleCase.append(StringUtils.capitalize(i.toLowerCase())+" ");
		}
		return titleCase.toString();
	}
	/**
	 *
	 * @param input AKKPM-1991- Q
	 * @return AKKPM1991Q
	 */
	public static String removeDash(final String input) {
		if(StringUtils.isEmpty(input)){
			return input;
		}
		StringBuffer titleCase = new StringBuffer();
		String[] tokens = input.split("-");
		for (String i : tokens) {
			i = StringUtils.trimWhitespace(i);
			titleCase.append(i);
		}
		return titleCase.toString();
	}
	public static String toUpperCase(final String input) {
		if(StringUtils.isEmpty(input)){
			return input;
		}
		return input.toUpperCase();
	}
	public static String[] convertIntArraytoStringArray(final int[] iarray) {
		if (iarray != null && iarray.length != 0) {
			String[] sarray = new String[iarray.length];
			for (int i=0;i<iarray.length;i++) {
				sarray[i] = replace0withNA(iarray[i]);
			}
			return sarray;
		}
		return null;
	}
	public static final String format(final double no) {
		NumberFormat formatter = new DecimalFormat("#.##");
		return formatter.format(no);
	}
}
