package me.parakh.core.security.jwt;

import java.util.List;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

/**
 * 
 * @author Kevendra Patidar
 */
@JsonInclude(Include.NON_NULL)
public class JwtClaim extends JwtClaimStandard {

	/* ************************************ Instance Fields ************************************ */
	private Long uid;//userId
	private String usr;//userName
	private String did;//deviceId
	private String dtp;//deviceType not require
	private String ver;//app version
	private List<String> secTp;//securableTypes
	private List<String> rol;//role
	
	/* ************************************ Public Methods ************************************ */	
	@Override
	public String toString() {
		return "JwtClaim [uid=" + uid + ", usr=" + usr + ", did=" + did
				+ ", dtp=" + dtp + ", ver=" + ver + ", secTp=" + secTp
				+ ", rol=" + rol + "]";
	}

	/* ************************************ Getters and Setters ************************************ */
	public Long getUid() {
		return uid;
	}
	public void setUid(Long uid) {
		this.uid = uid;
	}
	public String getUsr() {
		return usr;
	}
	public void setUsr(String usr) {
		this.usr = usr;
	}
	public String getDid() {
		return did;
	}
	public void setDid(String did) {
		this.did = did;
	}
	public String getDtp() {
		return dtp;
	}
	public void setDtp(String dtp) {
		this.dtp = dtp;
	}
	public String getVer() {
		return ver;
	}
	public void setVer(String ver) {
		this.ver = ver;
	}
	public List<String> getSecTp() {
		return secTp;
	}
	public void setSecTp(List<String> secTp) {
		this.secTp = secTp;
	}
	public List<String> getRol() {
		return rol;
	}
	public void setRol(List<String> rol) {
		this.rol = rol;
	}
		
}
