package me.parakh.core.security.jwt;

import java.util.Date;
import java.util.List;
import java.util.Map;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

/**
 * 
 * @author Kevendra Patidar
 */
@JsonInclude(Include.NON_NULL)
public class JwtClaimEdge extends JwtClaim {
	
	/* ************************************ Instance Fields ************************************ */
	private String userId;
	private String iamToken;
	private Date iamTokenExpiration;
	private String firstName;
	private String lastName;
	private String email;
	private Boolean cobaltUser;
	private Map<String, List<String>> authorities;
	
	/* ************************************ Public Methods ************************************ */	
	@Override
	public String toString() {
		return "JwtClaimEdge [userId=" + userId + ", iamToken=" + iamToken
				+ ", iamTokenExpiration=" + iamTokenExpiration + ", firstName="
				+ firstName + ", lastName=" + lastName + ", email=" + email
				+ ", cobaltUser=" + cobaltUser + ", authorities=" + authorities
				+ "]";
	}
	
	/* ************************************ Getters and Setters ************************************ */
	public String getUserId() {
		return userId;
	}
	public void setUserId(String userId) {
		this.userId = userId;
	}
	public String getIamToken() {
		return iamToken;
	}
	public void setIamToken(String iamToken) {
		this.iamToken = iamToken;
	}
	public Date getIamTokenExpiration() {
		return iamTokenExpiration;
	}
	public void setIamTokenExpiration(Date iamTokenExpiration) {
		this.iamTokenExpiration = iamTokenExpiration;
	}
	public String getFirstName() {
		return firstName;
	}
	public void setFirstName(String firstName) {
		this.firstName = firstName;
	}
	public String getLastName() {
		return lastName;
	}
	public void setLastName(String lastName) {
		this.lastName = lastName;
	}
	public String getEmail() {
		return email;
	}
	public void setEmail(String email) {
		this.email = email;
	}
	public Boolean getCobaltUser() {
		return cobaltUser;
	}
	public void setCobaltUser(Boolean cobaltUser) {
		this.cobaltUser = cobaltUser;
	}
	public Map<String, List<String>> getAuthorities() {
		return authorities;
	}
	public void setAuthorities(Map<String, List<String>> authorities) {
		this.authorities = authorities;
	}
		
}
