package me.parakh.core.security.jwt;

import java.util.Date;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonInclude.Include;

/**
 * The Internet drafts define the following standard fields ("claims") that can be used inside a JWT claim set:
 * 
 * JWT ID (jti) - case sensitive unique identifier of the token even among different issuers.
 * Issuer (iss) - identifies principal that issued the JWT;
 * Subject (sub) - identifies the subject of the JWT;
 * Audience (aud) - The "aud" (audience) claim identifies the recipients that the JWT is intended for. Each principal intended to process the JWT MUST identify itself with a value in the audience claim. If the principal processing the claim does not identify itself with a value in the aud claim when this claim is present, then the JWT MUST be rejected.
 * Expiration time (exp) - The "exp" (expiration time) claim identifies the expiration time on or after which the JWT MUST NOT be accepted for processing.
 * Not before (nbf) - Similarly, the not-before time claim identifies the time on which the JWT will start to be accepted for processing.
 * Issued at (iat) - The "iat" (issued at) claim identifies the time at which the JWT was issued.
 * 
 * @author Kevendra Patidar
 */
@JsonInclude(Include.NON_NULL)
public class JwtClaimStandard {

	/* ************************************ Instance Fields ************************************ */
	private String jti;
	private String iss;
	private String sub;
	private String aud;
	private Date exp;
	private Date nbf;
	private Date iat;
	
	/* ************************************ Public Methods ************************************ */	
	@Override
	public String toString() {
		return "JwtClaimStandard [jti=" + jti + ", iss=" + iss + ", sub=" + sub
				+ ", aud=" + aud + ", exp=" + exp + ", nbf=" + nbf + ", iat="
				+ iat + "]";
	}

	/* ************************************ Getters and Setters ************************************ */
	public String getJti() {
		return jti;
	}
	public void setJti(String jti) {
		this.jti = jti;
	}
	public String getIss() {
		return iss;
	}
	public void setIss(String iss) {
		this.iss = iss;
	}
	public String getSub() {
		return sub;
	}
	public void setSub(String sub) {
		this.sub = sub;
	}
	public String getAud() {
		return aud;
	}
	public void setAud(String aud) {
		this.aud = aud;
	}
	public Date getExp() {
		return exp;
	}
	public void setExp(Date exp) {
		this.exp = exp;
	}
	public Date getNbf() {
		return nbf;
	}
	public void setNbf(Date nbf) {
		this.nbf = nbf;
	}
	public Date getIat() {
		return iat;
	}
	public void setIat(Date iat) {
		this.iat = iat;
	}
	
}
