package me.parakh.core.security.util;

import me.parakh.core.dto.common.UserDto;
import me.parakh.core.security.jwt.JwtClaimEdge;

import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;


/**
 *
 * @author Kevendra Patidar
 */
public abstract class SecurityUtility {

	/* ************************************ Static Fields ************************************ */


	/* ************************************ Public Methods ************************************ */
	public static final UserDto getUser(){
		Authentication authentication = getAuthentication();
		Object principal = authentication.getPrincipal();
		UserDto user = null;
		if (principal instanceof UserDto) {
			user = (UserDto) principal;
			user.setPassword(null);
		}
		return user;
	}
	public static final String getUsername(){
		Authentication authentication = getAuthentication();
		if (authentication == null) {
			throw new IllegalStateException("Unable to get a ConnectionRepository: no user signed in");
		}
		return authentication.getName();
	}
	public static final JwtClaimEdge getClaim(){
		Authentication authentication = getAuthentication();
		if (authentication == null) {
			throw new IllegalStateException("Unable to get a ConnectionRepository: no user signed in");
		}
		return (JwtClaimEdge) authentication.getDetails();
	}
	
//	public static final Long getOrgId(){
//		User user = getUser();
//		if (null == user) {
//			return null;
//		}
//		return user.getOrgId();
//	}
//	public static final Map<String, Object> getDetails(){
//		User user = getUser();
//		if (null == user) {
//			return null;
//		}
//		return user.getDetails();
//	}
//	public static final Role getRole(){//FIXME String []
//		try{
//			Authentication authentication = getAuthentication();
//			if(!CollectionUtils.isEmpty(authentication.getAuthorities())){
//				GrantedAuthority authority = authentication.getAuthorities().iterator().next();
//				return Role.valueOf(authority.getAuthority());
//			}
//		}catch(Exception e){
//			e.printStackTrace();
//		}
//		return Role.ROLE_ANONYMOUS;
//	}
	/**
	 * RandomStringUtils.random(64); //random(count, false, false)
	 * RandomStringUtils.randomAlphanumeric(64);//random(count, true, true);
	 * RandomStringUtils.randomNumeric(64);//random(count, false, true)
	 * RandomStringUtils.randomAlphabetic(64); //random(count, true, false)
	 * RandomStringUtils.randomAscii(32);
	 * RandomStringUtils.random(32, 0, 20, true, true, "qw32rfHIJk9iQ8Ud7h0X".toCharArray());
	 * @return
	 */
	public static String randomPassword(){
		return RandomStringUtils.randomNumeric(6);
	}

	/* ************************************ Protected Methods ************************************ */
	protected static final Authentication getAuthentication(){
		return SecurityContextHolder.getContext().getAuthentication();
	}

	/* ************************************ Private Methods ************************************ */
}