/*
 * Decompiled with CFR 0.152.
 */
package me.parakh.core.security.filter;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import javax.annotation.PostConstruct;
import me.parakh.core.model.util.DateUtility;
import me.parakh.core.security.filter.JwtTokenService;
import me.parakh.core.security.jwt.JwtClaim;
import me.parakh.core.security.jwt.JwtClaimEdge;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.security.crypto.codec.Base64;
import org.springframework.security.jwt.Jwt;
import org.springframework.security.jwt.JwtHelper;
import org.springframework.security.jwt.crypto.sign.MacSigner;
import org.springframework.security.jwt.crypto.sign.SignatureVerifier;
import org.springframework.security.jwt.crypto.sign.Signer;
import org.springframework.security.jwt.crypto.sign.SignerVerifier;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;
import org.springframework.util.StringUtils;

@Service
public class JwtTokenServiceImpl
implements JwtTokenService {
    private static final Logger LOG = LoggerFactory.getLogger(JwtTokenServiceImpl.class);
    private ObjectMapper objectMapper = new ObjectMapper();
    private SignerVerifier signerVerifier;
    @Value(value="${signer.secret:secretkey}")
    public String secret;
    @Value(value="${signer.secret.base64.encoded:false}")
    public Boolean secretBase64Encoded;
    @Value(value="${token.expiry.days:45}")
    private Integer tokenExpiryDays;

    @PostConstruct
    public void initIt() throws Exception {
        Assert.notNull((Object)this.secret, (String)"secret must not be null");
        if (this.secretBase64Encoded.booleanValue()) {
            byte[] base64Decode = Base64.decode((byte[])this.secret.getBytes());
            String base64DecodeSecret = new String(base64Decode);
            this.signerVerifier = new MacSigner(base64DecodeSecret);
        } else {
            this.signerVerifier = new MacSigner(this.secret);
        }
    }

    @Override
    public String sign(JwtClaim claims) {
        this.updateMetadeta(claims);
        String jsonClaims = this.toJson(claims);
        if (StringUtils.isEmpty((Object)jsonClaims)) {
            return null;
        }
        Jwt jwt = JwtHelper.encode((CharSequence)jsonClaims, (Signer)this.signerVerifier);
        return jwt.getEncoded();
    }

    @Override
    public JwtClaimEdge verify(String token) {
        Jwt jwt = JwtHelper.decodeAndVerify((String)token, (SignatureVerifier)this.signerVerifier);
        return this.toJava(jwt.getClaims(), JwtClaimEdge.class);
    }

    private void updateMetadeta(JwtClaim claims) {
        claims.setIss("CDK Edge");
        claims.setExp(DateUtility.addDays((int)this.tokenExpiryDays));
    }

    private <T> T toJava(String json, Class<T> valueType) {
        try {
            return (T)this.objectMapper.readValue(json, valueType);
        }
        catch (Exception e) {
            LOG.error("error during convert JSON String into Java object", (Throwable)e);
            return null;
        }
    }

    private String toJson(Object value) {
        try {
            return this.objectMapper.writeValueAsString(value);
        }
        catch (JsonProcessingException e) {
            LOG.error("Json Processing Exception", (Throwable)e);
        }
        catch (Exception e) {
            LOG.error("error during convert Java object to JSON String ", (Throwable)e);
        }
        return null;
    }
}

