package me.parakh.core.security.handler;

import java.io.IOException;

import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.http.HttpStatus;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.web.AuthenticationEntryPoint;
import org.springframework.stereotype.Component;

/**
 * The <code>commence</code> method will always return an {@link org.springframework.http.HttpStatus#UNAUTHORIZED} (401) error.
 * 
 * HttpAuthenticationEntryPoint OR 
 * UnauthorizedEntryPointHandler
 * JwtAuthenticationEntryPoint
 * Http401DeniedEntryPoint
 * RestAuthenticationEntryPoint
 * 
 * 
 * @author Kevendra Patidar
 */
@Component
public class UnauthorizedEntryPointHandler implements AuthenticationEntryPoint{

	@Override
	public void commence(HttpServletRequest request, HttpServletResponse response, AuthenticationException authException) throws IOException, ServletException {
		HttpStatus unauthorized = HttpStatus.UNAUTHORIZED;
        response.sendError(unauthorized.value(), unauthorized.getReasonPhrase());
        
		//response.sendError(HttpServletResponse.SC_UNAUTHORIZED, "Access Denied");
		//response.sendError(HttpServletResponse.SC_UNAUTHORIZED, authException.getMessage());
	}

}
