/*
 * Decompiled with CFR 0.152.
 */
package me.parakh.core.security.util;

import me.parakh.core.dto.common.UserDto;
import me.parakh.core.security.jwt.JwtClaimEdge;
import org.apache.commons.lang3.RandomStringUtils;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;

public abstract class SecurityUtility {
    public static final UserDto getUser() {
        Authentication authentication = SecurityUtility.getAuthentication();
        Object principal = authentication.getPrincipal();
        UserDto user = null;
        if (principal instanceof UserDto) {
            user = (UserDto)principal;
            user.setPassword(null);
        }
        return user;
    }

    public static final String getUsername() {
        Authentication authentication = SecurityUtility.getAuthentication();
        if (authentication == null) {
            throw new IllegalStateException("Unable to get a ConnectionRepository: no user signed in");
        }
        return authentication.getName();
    }

    public static final JwtClaimEdge getClaim() {
        Authentication authentication = SecurityUtility.getAuthentication();
        if (authentication == null) {
            throw new IllegalStateException("Unable to get a ConnectionRepository: no user signed in");
        }
        return (JwtClaimEdge)authentication.getDetails();
    }

    public static String randomPassword() {
        return RandomStringUtils.randomNumeric((int)6);
    }

    protected static final Authentication getAuthentication() {
        return SecurityContextHolder.getContext().getAuthentication();
    }
}

