package me.parakh.core.security.handler;

import java.io.IOException;

import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import me.parakh.core.security.filter.CustomAuthenticationFilter;
import me.parakh.core.security.filter.JwtTokenService;
import me.parakh.core.security.jwt.JwtClaimEdge;
import me.parakh.core.service.security.AuthenticateService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AbstractAuthenticationTargetUrlRequestHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

/**
 * 
 * @author Kevendra Patidar
 */
@Component
public class AjaxLogoutSuccessHandler extends AbstractAuthenticationTargetUrlRequestHandler implements LogoutSuccessHandler {

	/* ************************************ Static Fields ************************************ */
	private static final Logger LOG = LoggerFactory.getLogger(AjaxLogoutSuccessHandler.class);
	
	/* ************************************ Instance Fields ************************************ */
	@Resource
    private JwtTokenService jwtTokenService;
	@Resource
	private AuthenticateService authenticateService;

	/* ************************************ Public Methods ************************************ */
	@Override
	public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        String token = request.getHeader(CustomAuthenticationFilter.DEFAULT_TOKEN_HEADER);
        if(StringUtils.hasText(token)){
        	try{
        		JwtClaimEdge claims = jwtTokenService.verify(token);
        		authenticateService.tokenRevoke(claims.getIamToken());//remove IAM token
        	}catch(Exception e){
        		LOG.error("onLogoutSuccess", e);
        	}
        }
		response.setStatus(HttpServletResponse.SC_OK);
		response.setHeader("auth-status", "signout");
	} 
	
}