package me.parakh.core.security.provider;

import java.util.ArrayList;
import java.util.List;

import javax.annotation.Resource;

import me.parakh.core.security.jwt.JwtClaimEdge;
import me.parakh.core.service.security.AuthenticateService;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Service;


/**
 * 
 * @author Kevendra Patidar
 */
@Service
public class CustomAuthenticationProvider implements AuthenticationProvider {
	
	/* ************************************ Static Fields ************************************ */
	private static final Logger LOG = LoggerFactory.getLogger(CustomAuthenticationProvider.class);

	/* ************************************ Instance Fields ************************************ */
	@Resource
	private AuthenticateService authenticateService;
	
	/* ************************************ Public Methods ************************************ */
	/**
	 * called by spring security authenticationManager.authenticate
	 * @see me.parakh.core.security.filter.CustomAuthenticationFilter#attemptAuthentication
	 * @see UserNamePasswordAuthenticationFilter
	 */
	@Override
	public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String userName = authentication.getName();
        String password = authentication.getCredentials().toString();
        
        JwtClaimEdge claims = null;
        if(authentication.getDetails() instanceof JwtClaimEdge){
        	claims = (JwtClaimEdge) authentication.getDetails();
        }else{
        	/* UserNamePasswordAuthenticationFilter call second time CustomAuthenticationProvider.authenticate */
        	return successfulAuthObject(userName, password);
        }
        if(null == claims){
        	claims = new JwtClaimEdge();
        }		  
		// 1. Use the username to load the data for the user, including authorities and password.
        if(authenticateService.authenticate(userName, password, claims)) {
            return successfulAuthObject(userName, password);
        }else{
        	LOG.warn("Bad Credentials");
        	// 2. Check the passwords match.
        	//if (!user.getPassword().equals(password)) {
        	throw new BadCredentialsException("Bad Credentials");
        }
    }
    @Override
	public boolean supports(Class<? extends Object> authentication) {
        return (UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication));
    }
    
    /* ************************************ Private Methods ************************************ */
	private Authentication successfulAuthObject(String userName, String password) {
		List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
		authorities.add(new SimpleGrantedAuthority("ROLE_USER"));//ROLE_ANONYMOUS
		
		User user = new User(userName, password, authorities);
		Authentication auth = new UsernamePasswordAuthenticationToken(user, password, authorities);
		return auth;
	}    
}
