package me.parakh.core.security.provider;


import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.core.userdetails.UserDetailsService;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Service;

/**
 * 
 * @author Kevendra Patidar
 */
@Service
public class UserDetailsServiceImpl implements UserDetailsService {


	/* ************************************ Static Fields ************************************ */
	private static final Logger LOG = LoggerFactory.getLogger(UserDetailsServiceImpl.class);

	/* ************************************ Public Methods ************************************ */
	@Override
	public UserDetails loadUserByUsername(String username) throws UsernameNotFoundException {
		List<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
		authorities.add(new SimpleGrantedAuthority("ROLE_ADMIN"));

		User user = new User(username, "<StandardPasswordEncoder encripted password>", authorities);

		// User user = this.userRepository.findByUsername(username);
		// if (user == null) throw new UsernameNotFoundException(String.format("No user found with username '%s'.",username));

		LOG.info("XXXXXXX user " + user);
		return user;
	}

}
