package me.parakh.core.security.service.impl;

import me.parakh.core.security.jwt.JwtClaimEdge;
import me.parakh.core.security.util.SecurityUtility;
import me.parakh.core.service.security.AuthClaimService;

import org.springframework.stereotype.Service;

/**
 * 
 * @author Kevendra Patidar
 */
@Service
public class AuthClaimServiceImpl implements AuthClaimService {

	@Override
	public JwtClaimEdge getClaim() {
		JwtClaimEdge claim = SecurityUtility.getClaim();
		return claim;
	}

	@Override
	public String getUserName() {
		return SecurityUtility.getUsername();
	}

	@Override
	public Long getUserId() {
		JwtClaimEdge claim = SecurityUtility.getClaim();
		if(null == claim){
			return null;
		}
		return claim.getUid();
	}

}
