/*
 * Decompiled with CFR 0.152.
 */
package me.parakh.core.security.filter;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.PostConstruct;
import javax.annotation.Resource;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.parakh.core.security.filter.CustomAuthenticationException;
import me.parakh.core.security.filter.JwtTokenService;
import me.parakh.core.security.jwt.JwtClaim;
import me.parakh.core.security.jwt.JwtClaimEdge;
import me.parakh.core.service.security.AuthenticateService;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Configuration;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.InternalAuthenticationServiceException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.security.web.authentication.AuthenticationFailureHandler;
import org.springframework.security.web.authentication.AuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SavedRequestAwareAuthenticationSuccessHandler;
import org.springframework.security.web.authentication.SimpleUrlAuthenticationFailureHandler;
import org.springframework.security.web.util.matcher.AntPathRequestMatcher;
import org.springframework.security.web.util.matcher.RequestMatcher;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.GenericFilterBean;

@Configuration
public class CustomAuthenticationFilter
extends GenericFilterBean {
    public static final String DEFAULT_TOKEN_HEADER = "Authorization";
    public static final String SPRING_SECURITY_FORM_USERNAME_KEY = "username";
    public static final String SPRING_SECURITY_FORM_PASSWORD_KEY = "password";
    private String userNameParameter = "username";
    private String passwordParameter = "password";
    private String tokenHeader = "Authorization";
    @Resource
    private AuthenticationManager authenticationManager;
    @Resource
    private JwtTokenService jwtTokenService;
    @Value(value="${url.signin:/api/auth/signin}")
    public String signinUrl;
    private RequestMatcher loginRequestMatcher;
    private AuthenticationSuccessHandler successHandler = new SavedRequestAwareAuthenticationSuccessHandler();
    private AuthenticationFailureHandler failureHandler = new SimpleUrlAuthenticationFailureHandler();
    @Resource
    private AuthenticateService authenticateService;

    @PostConstruct
    public void initIt() throws Exception {
        this.loginRequestMatcher = new AntPathRequestMatcher(this.signinUrl, "POST");
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if (this.loginRequestMatcher.matches(request)) {
            try {
                Authentication authentication = this.attemptAuthentication(request, response);
                if (authentication == null) {
                    return;
                }
                this.successfulLogin(request, response, authentication);
                SecurityContextHolder.getContext().setAuthentication(authentication);
            }
            catch (InternalAuthenticationServiceException failed) {
                this.logger.error((Object)"An internal error occurred while trying to authenticate the user", (Throwable)failed);
                this.unsuccessfulLogin(request, response, (AuthenticationException)((Object)failed));
                return;
            }
            catch (AuthenticationException failed) {
                this.unsuccessfulLogin(request, response, failed);
                return;
            }
        }
        String token = request.getHeader(this.tokenHeader);
        if (StringUtils.isEmpty((Object)token)) {
            this.unsuccessfulLogin(request, response, new CustomAuthenticationException("Empty token"));
            return;
        }
        if (DEFAULT_TOKEN_HEADER.equalsIgnoreCase(this.tokenHeader)) {
            String authorizationSchema = "Bearer";
            if (token.indexOf(authorizationSchema) == -1) {
                // empty if block
            }
            token = token.substring(authorizationSchema.length()).trim();
        }
        try {
            Authentication authResult = this.attemptTokenAuthentication(token);
            if (authResult != null) {
                SecurityContextHolder.getContext().setAuthentication(authResult);
            }
        }
        catch (Exception e) {
            this.logger.debug((Object)"JWT verification failed: ", (Throwable)e);
            this.unsuccessfulLogin(request, response, new CustomAuthenticationException("Invalid token"));
            return;
        }
        chain.doFilter(req, res);
    }

    protected Authentication attemptAuthentication(HttpServletRequest request, HttpServletResponse response) {
        String username = this.obtainUsername(request);
        String password = this.obtainPassword(request);
        if (StringUtils.isEmpty((Object)username)) {
            username = "";
        }
        if (StringUtils.isEmpty((Object)password)) {
            password = "";
        }
        username = username.trim();
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        JwtClaimEdge claims = new JwtClaimEdge();
        claims.setDid(request.getParameter("deviceId"));
        claims.setDtp(request.getParameter("deviceType"));
        authRequest.setDetails((Object)claims);
        return this.authenticationManager.authenticate((Authentication)authRequest);
    }

    protected String obtainUsername(HttpServletRequest request) {
        return request.getParameter(this.userNameParameter);
    }

    protected String obtainPassword(HttpServletRequest request) {
        return request.getParameter(this.passwordParameter);
    }

    protected void successfulLogin(HttpServletRequest request, HttpServletResponse response, Authentication authResult) throws IOException, ServletException {
        this.logger.debug((Object)("Authentication request success: " + authResult));
        JwtClaimEdge claims = null;
        try {
            claims = this.provideClaims(request, authResult);
        }
        catch (Exception e) {
            this.logger.error((Object)"provide claims failed", (Throwable)e);
        }
        String token = this.jwtTokenService.sign((JwtClaim)claims);
        response.setHeader(this.tokenHeader, token);
    }

    protected void successfulAuthentication(HttpServletRequest request, HttpServletResponse response, FilterChain chain, Authentication authResult) throws IOException, ServletException {
        SecurityContextHolder.getContext().setAuthentication(authResult);
        this.successHandler.onAuthenticationSuccess(request, response, authResult);
    }

    protected void unsuccessfulLogin(HttpServletRequest request, HttpServletResponse response, AuthenticationException failed) throws IOException, ServletException {
        SecurityContextHolder.clearContext();
        this.failureHandler.onAuthenticationFailure(request, response, failed);
    }

    protected JwtClaimEdge provideClaims(HttpServletRequest request, Authentication authResult) {
        UserDetails userDetails = (UserDetails)authResult.getPrincipal();
        String userName = userDetails.getUsername();
        ArrayList<String> roles = new ArrayList<String>();
        for (GrantedAuthority authority : userDetails.getAuthorities()) {
            roles.add(authority.getAuthority());
        }
        JwtClaimEdge claims = (JwtClaimEdge)authResult.getDetails();
        claims.setUsr(userName);
        claims.setRol(roles);
        return claims;
    }

    protected Authentication attemptTokenAuthentication(String token) throws AuthenticationException, IOException, ServletException {
        JwtClaimEdge claims = this.jwtTokenService.verify(token);
        String userName = claims.getUsr();
        List<GrantedAuthority> authorities = this.obtainAuthoritiesFromClaims(claims.getRol());
        if (userName == null || authorities == null) {
            throw new IllegalStateException("Claims 'username' and/or 'authorities' cannot be null");
        }
        if (!this.authenticateService.tokenVerify(claims.getIamToken())) {
            throw new IllegalStateException("invalid IAM token ");
        }
        UsernamePasswordAuthenticationToken authentication = new UsernamePasswordAuthenticationToken((Object)userName, null, authorities);
        authentication.setDetails((Object)claims);
        return authentication;
    }

    protected String obtainUsernameFromClaims(Map<String, Object> claims) {
        return (String)claims.get(SPRING_SECURITY_FORM_USERNAME_KEY);
    }

    protected List<GrantedAuthority> obtainAuthoritiesFromClaims(List<String> roles) {
        ArrayList<GrantedAuthority> authorities = new ArrayList<GrantedAuthority>();
        for (String role : roles) {
            authorities.add((GrantedAuthority)new SimpleGrantedAuthority(role));
        }
        return authorities;
    }
}

