/*
 * Decompiled with CFR 0.152.
 */
package me.parakh.core.security.handler;

import java.io.IOException;
import javax.annotation.Resource;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import me.parakh.core.security.filter.JwtTokenService;
import me.parakh.core.security.jwt.JwtClaimEdge;
import me.parakh.core.service.security.AuthenticateService;
import org.springframework.security.core.Authentication;
import org.springframework.security.web.authentication.AbstractAuthenticationTargetUrlRequestHandler;
import org.springframework.security.web.authentication.logout.LogoutSuccessHandler;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class AjaxLogoutSuccessHandler
extends AbstractAuthenticationTargetUrlRequestHandler
implements LogoutSuccessHandler {
    @Resource
    private JwtTokenService jwtTokenService;
    @Resource
    private AuthenticateService authenticateService;

    public void onLogoutSuccess(HttpServletRequest request, HttpServletResponse response, Authentication authentication) throws IOException, ServletException {
        String token = request.getHeader("Authorization");
        if (StringUtils.hasText((String)token)) {
            JwtClaimEdge claims = this.jwtTokenService.verify(token);
            this.authenticateService.tokenRevoke(claims.getIamToken());
        }
        response.setStatus(200);
        response.setHeader("auth-status", "signout");
    }
}

