/*
 * Decompiled with CFR 0.152.
 */
package me.parakh.core.security.provider;

import java.util.ArrayList;
import javax.annotation.Resource;
import me.parakh.core.security.jwt.JwtClaimEdge;
import me.parakh.core.service.security.AuthenticateService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationProvider;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.core.userdetails.User;
import org.springframework.stereotype.Service;

@Service
public class CustomAuthenticationProvider
implements AuthenticationProvider {
    private static final Logger LOG = LoggerFactory.getLogger(CustomAuthenticationProvider.class);
    @Resource
    private AuthenticateService authenticateService;

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        String userName = authentication.getName();
        String password = authentication.getCredentials().toString();
        JwtClaimEdge claims = null;
        if (!(authentication.getDetails() instanceof JwtClaimEdge)) {
            return this.successfulAuthObject(userName, password);
        }
        claims = (JwtClaimEdge)authentication.getDetails();
        if (null == claims) {
            claims = new JwtClaimEdge();
        }
        if (this.authenticateService.authenticate(userName, password, claims)) {
            return this.successfulAuthObject(userName, password);
        }
        LOG.warn("Bad Credentials");
        throw new BadCredentialsException("Bad Credentials");
    }

    public boolean supports(Class<? extends Object> authentication) {
        return UsernamePasswordAuthenticationToken.class.isAssignableFrom(authentication);
    }

    private Authentication successfulAuthObject(String userName, String password) {
        ArrayList<SimpleGrantedAuthority> authorities = new ArrayList<SimpleGrantedAuthority>();
        authorities.add(new SimpleGrantedAuthority("ROLE_USER"));
        User user = new User(userName, password, authorities);
        UsernamePasswordAuthenticationToken auth = new UsernamePasswordAuthenticationToken((Object)user, (Object)password, authorities);
        return auth;
    }
}

