/*
 * Decompiled with CFR 0.152.
 */
package me.rochblondiaux.blockbench;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import me.rochblondiaux.blockbench.BlockBenchModelReader;
import me.rochblondiaux.blockbench.adapters.OutlinerGsonAdapter;
import me.rochblondiaux.blockbench.model.BlockBenchModel;
import me.rochblondiaux.blockbench.model.BlockBenchModelImpl;
import me.rochblondiaux.blockbench.outliner.OutlinerImpl;
import org.jetbrains.annotations.NotNull;

public class BlockBenchModelReaderImpl
implements BlockBenchModelReader {
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(OutlinerImpl.class, (Object)new OutlinerGsonAdapter()).create();

    @Override
    @NotNull
    public BlockBenchModel read(@NotNull InputStream input) {
        BlockBenchModel blockBenchModel;
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(input));
        try {
            blockBenchModel = (BlockBenchModel)GSON.fromJson((Reader)bufferedReader, BlockBenchModelImpl.class);
        }
        catch (Throwable throwable) {
            try {
                try {
                    bufferedReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to read BlockBench model from input stream", e);
            }
        }
        bufferedReader.close();
        return blockBenchModel;
    }

    @Override
    @NotNull
    public BlockBenchModel read(@NotNull Path path) {
        BlockBenchModel blockBenchModel;
        block8: {
            InputStream input = Files.newInputStream(path, new OpenOption[0]);
            try {
                blockBenchModel = this.read(input);
                if (input == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (input != null) {
                        try {
                            input.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to read BlockBench model from path: " + path, e);
                }
            }
            input.close();
        }
        return blockBenchModel;
    }
}

