/*
 * Decompiled with CFR 0.152.
 */
package me.rochblondiaux.blockbench.adapters;

import com.google.gson.JsonDeserializationContext;
import com.google.gson.JsonDeserializer;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import java.lang.reflect.Type;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import me.rochblondiaux.blockbench.outliner.OutlinerImpl;

public class OutlinerGsonAdapter
implements JsonDeserializer<OutlinerImpl> {
    public OutlinerImpl deserialize(JsonElement jsonElement, Type type, JsonDeserializationContext jsonDeserializationContext) throws JsonParseException {
        Float[] floatArray;
        String nbt;
        if (jsonElement.isJsonPrimitive()) {
            return OutlinerImpl.redirect(UUID.fromString(jsonElement.getAsString()));
        }
        UUID uuid = UUID.fromString(jsonElement.getAsJsonObject().get("uuid").getAsString());
        String name = jsonElement.getAsJsonObject().get("name").getAsString();
        int color = jsonElement.getAsJsonObject().get("color").getAsInt();
        boolean export = this.getIfPresent(jsonElement, "export");
        boolean mirrorUV = this.getIfPresent(jsonElement, "mirrorUV");
        String string = nbt = jsonElement.getAsJsonObject().has("nbt") ? jsonElement.getAsJsonObject().get("nbt").getAsString() : null;
        if (jsonElement.getAsJsonObject().has("origin")) {
            floatArray = (Float[])jsonElement.getAsJsonObject().get("origin").getAsJsonArray().asList().stream().map(JsonElement::getAsFloat).toArray(Float[]::new);
        } else {
            Float[] floatArray2 = new Float[3];
            floatArray2[0] = Float.valueOf(0.0f);
            floatArray2[1] = Float.valueOf(0.0f);
            floatArray = floatArray2;
            floatArray2[2] = Float.valueOf(0.0f);
        }
        Float[] origin = floatArray;
        boolean visible = this.getIfPresent(jsonElement, "visible");
        List<OutlinerImpl> children = jsonElement.getAsJsonObject().get("children").getAsJsonArray().asList().stream().map(element -> this.deserialize((JsonElement)element, type, jsonDeserializationContext)).collect(Collectors.toList());
        return new OutlinerImpl(uuid, name, color, export, mirrorUV, nbt, origin, visible, children);
    }

    private boolean getIfPresent(JsonElement jsonElement, String key) {
        return jsonElement.getAsJsonObject().has(key) && jsonElement.getAsJsonObject().get(key).getAsBoolean();
    }
}

