/*
 * Decompiled with CFR 0.152.
 */
package me.rochblondiaux.blockbench.texture;

import com.google.gson.annotations.SerializedName;
import java.awt.image.BufferedImage;
import java.io.ByteArrayInputStream;
import java.util.Base64;
import java.util.UUID;
import javax.imageio.ImageIO;
import me.rochblondiaux.blockbench.texture.BlockbenchTexture;
import org.jetbrains.annotations.Nullable;
import team.unnamed.creative.base.Writable;

public record BlockBenchTextureImpl(@SerializedName(value="uuid") UUID uniqueId, String path, String name, String folder, String namespace, int id, int width, int height, @SerializedName(value="uv_width") int uvWidth, @SerializedName(value="uv_height") int uvHeight, boolean particle, @SerializedName(value="layers_enabled") boolean layersEnabled, @SerializedName(value="render_mode") String renderMode, @SerializedName(value="render_sides") boolean renderSides, @SerializedName(value="frame_time") int frameTime, @SerializedName(value="frame_order_type") String frameOrderType, @SerializedName(value="frame_interpolate") boolean frameInterpolate, boolean visible, boolean internal, boolean saved, @SerializedName(value="relative_path") String relativePath, String source) implements BlockbenchTexture
{
    @Override
    @Nullable
    public Writable asWritable() {
        if (this.source == null) {
            return null;
        }
        return Writable.inputStream(() -> {
            String data = this.source.substring(this.source.indexOf(",") + 1);
            byte[] imageContent = Base64.getDecoder().decode(data);
            return new ByteArrayInputStream(imageContent);
        });
    }

    @Override
    public BufferedImage image() {
        BufferedImage bufferedImage;
        if (this.source == null) {
            return null;
        }
        String data = this.source.substring(this.source.indexOf(",") + 1);
        byte[] imageContent = Base64.getDecoder().decode(data);
        ByteArrayInputStream stream = new ByteArrayInputStream(imageContent);
        try {
            bufferedImage = ImageIO.read(stream);
        }
        catch (Throwable throwable) {
            try {
                try {
                    stream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to read image from source", e);
            }
        }
        stream.close();
        return bufferedImage;
    }
}

