/*
 * Decompiled with CFR 0.152.
 */
package me.rochblondiaux.gameanalytics;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.IOException;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import lombok.Generated;
import me.rochblondiaux.gameanalytics.adapter.BusinessEventSerializer;
import me.rochblondiaux.gameanalytics.adapter.DesignEventSerializer;
import me.rochblondiaux.gameanalytics.adapter.ErrorEventSerializer;
import me.rochblondiaux.gameanalytics.adapter.ProgressionEventSerializer;
import me.rochblondiaux.gameanalytics.adapter.ResourceEventSerializer;
import me.rochblondiaux.gameanalytics.model.event.implementation.BusinessEvent;
import me.rochblondiaux.gameanalytics.model.event.implementation.DesignEvent;
import me.rochblondiaux.gameanalytics.model.event.implementation.ErrorEvent;
import me.rochblondiaux.gameanalytics.model.event.implementation.Event;
import me.rochblondiaux.gameanalytics.model.event.implementation.ProgressionEvent;
import me.rochblondiaux.gameanalytics.model.event.implementation.ResourceEvent;
import me.rochblondiaux.gameanalytics.request.InitRequest;
import me.rochblondiaux.gameanalytics.response.InitResponse;
import me.rochblondiaux.gameanalytics.utils.GzipUtil;
import me.rochblondiaux.gameanalytics.utils.HmacUtil;
import okhttp3.Call;
import okhttp3.Callback;
import okhttp3.HttpUrl;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.ResponseBody;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class GameAnalytics {
    public static final String PRODUCTION_ENDPOINT = "api.gameanalytics.com";
    public static final String SANDBOX_ENDPOINT = "sandbox-api.gameanalytics.com";
    public static final String VERSION = "rest api v2";
    private static final Gson GSON = new GsonBuilder().registerTypeHierarchyAdapter(ResourceEvent.class, (Object)new ResourceEventSerializer()).registerTypeHierarchyAdapter(BusinessEvent.class, (Object)new BusinessEventSerializer()).registerTypeHierarchyAdapter(ErrorEvent.class, (Object)new ErrorEventSerializer()).registerTypeHierarchyAdapter(DesignEvent.class, (Object)new DesignEventSerializer()).registerTypeHierarchyAdapter(ProgressionEvent.class, (Object)new ProgressionEventSerializer()).create();
    private final String gameKey;
    private final String secretKey;
    private final String endpoint;
    private final OkHttpClient httpClient;

    public GameAnalytics(String gameKey, String secretKey, Environment environment) {
        this(gameKey, secretKey, environment, new OkHttpClient());
    }

    public GameAnalytics(String gameKey, String secretKey, Environment environment, OkHttpClient httpClient) {
        this.gameKey = gameKey;
        this.secretKey = secretKey;
        this.endpoint = environment.endpoint();
        this.httpClient = httpClient;
    }

    public CompletableFuture<InitResponse> init(int interval, @NotNull InitRequest request) {
        return this.init(interval, null, request);
    }

    public CompletableFuture<InitResponse> init(int interval, @Nullable String configHash, @NotNull InitRequest request) {
        HttpUrl.Builder url = new HttpUrl.Builder().scheme("https").host(this.endpoint).addPathSegment("remote_configs").addPathSegment("v1").addPathSegment("init").addQueryParameter("game_key", this.gameKey).addQueryParameter("interval_seconds", String.valueOf(interval));
        if (configHash != null) {
            url.addQueryParameter("configs_hash", configHash);
        }
        return this.sendRequest(url.build(), request, InitResponse.class);
    }

    public CompletableFuture<Void> sendEvents(List<Event> events) {
        if (events.isEmpty()) {
            return CompletableFuture.completedFuture(null);
        }
        HttpUrl.Builder url = new HttpUrl.Builder().scheme("https").host(this.endpoint).addPathSegment("v2").addPathSegment(this.gameKey).addPathSegment("events");
        return this.sendRequest(url.build(), events, Void.class);
    }

    private <T> CompletableFuture<T> sendRequest(HttpUrl url, Object content, Class<T> responseType) {
        String jsonContent = GSON.toJson(content);
        System.out.println("Sending request to " + String.valueOf(url) + " with content: " + jsonContent);
        return this.sendRequest(url, jsonContent, responseType);
    }

    private <T> CompletableFuture<T> sendRequest(HttpUrl url, String content, final Class<T> responseType) {
        byte[] compressedContent;
        try {
            compressedContent = GzipUtil.gzip(content);
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to compress content", e);
        }
        Request request = new Request.Builder().url(url).addHeader("Authorization", HmacUtil.generateHmac(compressedContent, this.secretKey)).addHeader("Content-Type", "application/json").addHeader("Content-Length", String.valueOf(compressedContent.length)).addHeader("Content-Encoding", "gzip").post(RequestBody.create((byte[])compressedContent, (MediaType)MediaType.parse((String)"application/json"))).build();
        final CompletableFuture future = new CompletableFuture();
        this.httpClient.newCall(request).enqueue(new Callback(){

            public void onFailure(@NotNull Call call, @NotNull IOException e) {
                future.completeExceptionally(e);
            }

            public void onResponse(@NotNull Call call, @NotNull Response response) throws IOException {
                if (!response.isSuccessful()) {
                    try (ResponseBody body = response.body();){
                        if (body == null) {
                            future.completeExceptionally(new IOException("Unexpected response code: " + response.code() + " - " + response.message()));
                            return;
                        }
                        String errorBody = body.string();
                        future.completeExceptionally(new IOException("Unexpected response code: " + response.code() + " - " + errorBody));
                    }
                    return;
                }
                String responseBody = response.body().string();
                if (responseBody.isEmpty()) {
                    future.complete(null);
                } else {
                    System.out.println("Response: " + responseBody);
                    if (responseType == Void.class) {
                        future.complete(null);
                        return;
                    }
                    Object result = GSON.fromJson(responseBody, responseType);
                    future.complete(result);
                }
            }
        });
        return future;
    }

    @Generated
    public String gameKey() {
        return this.gameKey;
    }

    @Generated
    public String secretKey() {
        return this.secretKey;
    }

    @Generated
    public String endpoint() {
        return this.endpoint;
    }

    @Generated
    public OkHttpClient httpClient() {
        return this.httpClient;
    }

    public static enum Environment {
        PRODUCTION("api.gameanalytics.com"),
        SANDBOX("sandbox-api.gameanalytics.com");

        private final String endpoint;

        @Generated
        private Environment(String endpoint) {
            this.endpoint = endpoint;
        }

        @Generated
        public String endpoint() {
            return this.endpoint;
        }
    }
}

