/*
 * Decompiled with CFR 0.152.
 */
package me.rochblondiaux.gameanalytics.adapter;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonSerializationContext;
import com.google.gson.JsonSerializer;
import java.lang.reflect.Type;
import me.rochblondiaux.gameanalytics.model.event.implementation.ResourceEvent;

public class ResourceEventSerializer
implements JsonSerializer<ResourceEvent> {
    public JsonElement serialize(ResourceEvent resourceEvent, Type type, JsonSerializationContext jsonSerializationContext) {
        JsonObject jsonObject = new JsonObject();
        jsonObject.addProperty("category", resourceEvent.category().name().toLowerCase());
        jsonObject.addProperty("v", (Number)resourceEvent.version());
        jsonObject.addProperty("device", resourceEvent.device());
        jsonObject.addProperty("user_id", resourceEvent.userId());
        jsonObject.addProperty("client_ts", (Number)resourceEvent.clientTs());
        jsonObject.addProperty("sdk_version", resourceEvent.sdkVersion());
        jsonObject.addProperty("os_version", resourceEvent.osVersion());
        jsonObject.addProperty("manufacturer", resourceEvent.manufacturer());
        jsonObject.addProperty("platform", resourceEvent.platform());
        jsonObject.addProperty("session_id", resourceEvent.sessionId().toString());
        jsonObject.addProperty("session_num", (Number)resourceEvent.sessionNumber());
        jsonObject.addProperty("custom_01", resourceEvent.custom01());
        jsonObject.addProperty("custom_02", resourceEvent.custom02());
        jsonObject.addProperty("custom_03", resourceEvent.custom03());
        jsonObject.addProperty("build", resourceEvent.build());
        jsonObject.addProperty("event_id", "%s:%s:%s:%s".formatted(this.capitalize(resourceEvent.flowType().name()), this.capitalize(resourceEvent.currency().name()), resourceEvent.itemType(), resourceEvent.itemId()));
        jsonObject.addProperty("amount", (Number)resourceEvent.amount());
        return jsonObject;
    }

    private String capitalize(String str) {
        return str.substring(0, 1).toUpperCase() + str.substring(1).toLowerCase();
    }
}

