/*
 * Decompiled with CFR 0.152.
 */
package me.seroperson.urlopt4s;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;

class ReadOnlySeekableByteArrayChannel
implements SeekableByteChannel {
    private byte[] data;
    private int position;
    private boolean closed;

    public ReadOnlySeekableByteArrayChannel(byte[] byArray) {
        this.data = byArray;
    }

    @Override
    public long position() {
        return this.position;
    }

    @Override
    public SeekableByteChannel position(long l) throws IOException {
        this.ensureOpen();
        this.position = (int)Math.max(0L, Math.min(l, this.size()));
        return this;
    }

    @Override
    public long size() {
        return this.data.length;
    }

    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        this.ensureOpen();
        int n = (int)this.size() - this.position;
        if (n <= 0) {
            return -1;
        }
        int n2 = byteBuffer.remaining();
        if (n2 > n) {
            n2 = n;
        }
        byteBuffer.put(this.data, this.position, n2);
        this.position += n2;
        return n2;
    }

    @Override
    public void close() {
        this.closed = true;
    }

    @Override
    public boolean isOpen() {
        return !this.closed;
    }

    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public SeekableByteChannel truncate(long l) {
        throw new UnsupportedOperationException();
    }

    private void ensureOpen() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }
}

