/*
 * Decompiled with CFR 0.152.
 */
package me.seroperson.urlopt4s;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import java.nio.channels.SeekableByteChannel;

class SeekableInMemoryByteChannel
implements SeekableByteChannel {
    private int position;
    private volatile boolean open = true;
    private byte[] contents;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    SeekableInMemoryByteChannel() {
        SeekableInMemoryByteChannel seekableInMemoryByteChannel = this;
        synchronized (seekableInMemoryByteChannel) {
            this.position = 0;
            this.contents = new byte[0];
        }
    }

    @Override
    public boolean isOpen() {
        return this.open;
    }

    @Override
    public void close() throws IOException {
        this.open = false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read(ByteBuffer byteBuffer) throws IOException {
        byte[] byArray;
        int n;
        this.checkClosed();
        if (byteBuffer == null) {
            throw new IllegalArgumentException("Destination buffer must be supplied");
        }
        int n2 = byteBuffer.remaining();
        SeekableInMemoryByteChannel seekableInMemoryByteChannel = this;
        synchronized (seekableInMemoryByteChannel) {
            int n3 = this.contents.length - this.position;
            if (n3 < 0) {
                return 0;
            }
            n = n3 >= n2 ? n2 : n3;
            byArray = new byte[n];
            System.arraycopy(this.contents, this.position, byArray, 0, n);
            this.position += n;
        }
        byteBuffer.put(byArray);
        return n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int write(ByteBuffer byteBuffer) throws IOException {
        this.checkClosed();
        if (byteBuffer == null) {
            throw new IllegalArgumentException("Source buffer must be supplied");
        }
        int n = byteBuffer.remaining();
        byte[] byArray = new byte[n];
        byteBuffer.get(byArray);
        SeekableInMemoryByteChannel seekableInMemoryByteChannel = this;
        synchronized (seekableInMemoryByteChannel) {
            this.contents = this.concat(this.contents, byArray, this.position);
            this.position += n;
        }
        return n;
    }

    private byte[] concat(byte[] byArray, byte[] byArray2, int n) {
        assert (byArray != null) : "Input 1 must be specified";
        assert (byArray2 != null) : "Input 2 must be specified";
        assert (n >= 0) : "Position must be 0 or higher";
        int n2 = n < byArray.length ? byArray.length + byArray2.length : n + byArray2.length;
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, 0, byArray3, 0, byArray.length);
        System.arraycopy(byArray2, 0, byArray3, n, byArray2.length);
        return byArray3;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long position() throws IOException {
        SeekableInMemoryByteChannel seekableInMemoryByteChannel = this;
        synchronized (seekableInMemoryByteChannel) {
            return this.position;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel position(long l) throws IOException {
        if (l > Integer.MAX_VALUE || l < 0L) {
            throw new IllegalArgumentException("Valid position for this channel is between 0 and 2147483647");
        }
        SeekableInMemoryByteChannel seekableInMemoryByteChannel = this;
        synchronized (seekableInMemoryByteChannel) {
            this.position = (int)l;
        }
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long size() throws IOException {
        SeekableInMemoryByteChannel seekableInMemoryByteChannel = this;
        synchronized (seekableInMemoryByteChannel) {
            return this.contents.length;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SeekableByteChannel truncate(long l) throws IOException {
        if (l < 0L || l > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("This implementation permits a size of 0 to 2147483647 inclusive");
        }
        SeekableInMemoryByteChannel seekableInMemoryByteChannel = this;
        synchronized (seekableInMemoryByteChannel) {
            int n = (int)l;
            int n2 = (int)this.size();
            if (this.position > n) {
                this.position = n;
            }
            if (n2 > n) {
                byte[] byArray = new byte[n];
                System.arraycopy(this.contents, 0, byArray, 0, n);
                this.contents = byArray;
            }
            if (n > n2) {
                this.position = n;
            }
        }
        return this;
    }

    private void checkClosed() throws ClosedChannelException {
        if (!this.isOpen()) {
            throw new ClosedChannelException();
        }
    }
}

