/*
 * Decompiled with CFR 0.152.
 */
package slinky.readwrite;

import java.io.Serializable;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Product;
import scala.Some;
import scala.Some$;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.Iterator;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;
import scala.scalajs.js.Any;
import scala.scalajs.js.Any$;
import scala.scalajs.js.Dictionary;
import scala.scalajs.js.Dictionary$;
import scala.scalajs.js.Dynamic;
import scala.scalajs.js.package$;
import scala.util.control.NonFatal$;
import slinky.readwrite.ExoticTypes;
import slinky.readwrite.Writer;

public interface MacroWriters {

    public static class ProductWriter<T>
    implements Writer<T> {
        private final Product labels;
        private final Product writers;

        public <T> ProductWriter(Product labels, Product writers) {
            this.labels = labels;
            this.writers = writers;
        }

        @Override
        public scala.scalajs.js.Object write(T p) {
            Dictionary d = Dictionary$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[0]));
            this.labels.productIterator().zip((IterableOnce)this.writers.productIterator()).zip((IterableOnce)((Product)p).productIterator()).foreach((Function1 & Serializable)x$1 -> {
                this.write$$anonfun$1(d, (Tuple2)x$1);
                return BoxedUnit.UNIT;
            });
            return (scala.scalajs.js.Object)d;
        }

        private final /* synthetic */ void write$$anonfun$1(Dictionary d$1, Tuple2 x$1) {
            Tuple2 tuple2;
            Tuple2 tuple22 = x$1;
            if (tuple22 != null && (tuple2 = (Tuple2)tuple22._1()) != null) {
                Object value;
                Object label = tuple2._1();
                Object writer = tuple2._2();
                scala.scalajs.js.Object written = ((Writer)writer).write(value = tuple22._2());
                if (!package$.MODULE$.isUndefined((Object)written)) {
                    Any$.MODULE$.wrapDictionary(d$1).update((String)label, (Object)written);
                }
            } else {
                throw new MatchError((Object)tuple22);
            }
        }
    }

    public static class SumWriter<T>
    implements Writer<T> {
        private final Product labels;
        private final Product writers;
        private final Function1<T, Object> ordinal;

        public <T> SumWriter(Product labels, Product writers, Function1<T, Object> ordinal) {
            this.labels = labels;
            this.writers = writers;
            this.ordinal = ordinal;
        }

        @Override
        public scala.scalajs.js.Object write(T p) {
            int ord = BoxesRunTime.unboxToInt((Object)this.ordinal.apply(p));
            Object typ = this.labels.productElement(ord);
            scala.scalajs.js.Object base = ((Writer)this.writers.productElement(ord)).write(p);
            ((Dynamic)base).updateDynamic("_type", (Any)typ);
            ((Dynamic)base).updateDynamic("_ord", Any$.MODULE$.fromInt(ord));
            return base;
        }
    }

    public static class UnionWriter<T>
    implements Writer<T> {
        private final Product writers;
        private final Product classTags;

        public <T> UnionWriter(Product writers, Product classTags) {
            this.writers = writers;
            this.classTags = classTags;
        }

        @Override
        public scala.scalajs.js.Object write(T p) {
            scala.scalajs.js.Object object;
            Iterator iterator = this.classTags.productIterator();
            int n = iterator.indexWhere((Function1 & Serializable)_$1 -> {
                Class clazz = ((ClassTag)_$1).runtimeClass();
                Class<?> clazz2 = p.getClass();
                return !(clazz != null ? !clazz.equals(clazz2) : clazz2 != null);
            }, iterator.indexWhere$default$2());
            if (-1 == n) {
                ObjectRef lastEx = ObjectRef.create(null);
                object = (scala.scalajs.js.Object)this.writers.productIterator().map((Function1 & Serializable)w -> this.liftedTree1$1(p, lastEx, (Writer)w)).collectFirst((PartialFunction)new Serializable(){

                    public final boolean isDefinedAt(Option x) {
                        boolean bl;
                        Option option = x;
                        if (option instanceof Some) {
                            scala.scalajs.js.Object obj = (scala.scalajs.js.Object)((Some)option).value();
                            bl = true;
                        } else {
                            bl = false;
                        }
                        return bl;
                    }

                    public final Object applyOrElse(Option x, Function1 function1) {
                        Object object;
                        Option option = x;
                        if (option instanceof Some) {
                            scala.scalajs.js.Object obj = (scala.scalajs.js.Object)((Some)option).value();
                            object = obj;
                        } else {
                            object = function1.apply((Object)x);
                        }
                        return object;
                    }
                }).getOrElse(() -> this.write$$anonfun$3(lastEx));
            } else {
                int other = n;
                object = ((Writer)this.writers.productElement(other)).write(p);
            }
            return object;
        }

        private final Option liftedTree1$1(Object p$2, ObjectRef lastEx$1, Writer w$1) {
            Some some;
            try {
                some = Some$.MODULE$.apply((Object)w$1.write(p$2));
            }
            catch (Throwable throwable) {
                Option option;
                Throwable throwable2 = throwable;
                if (throwable2 != null && !(option = NonFatal$.MODULE$.unapply(throwable2)).isEmpty()) {
                    Throwable throwable3;
                    Throwable e;
                    Throwable throwable4 = e = (throwable3 = (Throwable)option.get());
                    lastEx$1.elem = throwable4;
                    some = None$.MODULE$;
                }
                throw throwable;
            }
            return some;
        }

        private final scala.scalajs.js.Object write$$anonfun$3(ObjectRef lastEx$3) {
            throw (Throwable)lastEx$3.elem;
        }
    }

    public static class ValueClassWriter<T, R>
    implements Writer<T> {
        private final ExoticTypes.ValueClass vc;
        private final Writer<R> w;

        public <T, R> ValueClassWriter(ExoticTypes.ValueClass vc, Writer<R> w) {
            this.vc = vc;
            this.w = w;
        }

        @Override
        public scala.scalajs.js.Object write(T p) {
            return this.w.write(this.vc.from(p));
        }
    }
}

