package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;abbr&gt;</code> element</strong> represents an abbreviation and optionally provides a full description for it. If present, the <code><a href="/en-US/docs/Web/HTML/Global_attributes#attr-title">title</a></code> attribute must contain this full description and nothing else.
 */
object abbr extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Element
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("abbr", mods)
}


}

object _abbr_attr {

}
