package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * form - A comma-separated list of content types that the server accepts. <div class="note"> <strong>Usage note:</strong> This attribute has been removed in HTML5 and should no longer be used. Instead, use the  <code><a href="/en-US/docs/Web/HTML/Element/input#attr-accept">accept</a></code> attribute of the specific  <a title="The HTML <input> element is used to create interactive controls for web-based forms in order to accept data from the user." href="/en-US/docs/Web/HTML/Element/input"><code>&lt;input&gt;</code></a> element.</div>
 * input - If the value of the <strong>type</strong> attribute is <code>file</code>, then this attribute will indicate&nbsp;the types of files that the server accepts,&nbsp;otherwise it will be&nbsp;ignored. The value must be a comma-separated list of unique content type specifiers: <ul>  <li>A file extension starting with the STOP character (U+002E). (e.g.&nbsp;.jpg, .png, .doc).</li>  <li>A valid MIME type with no extensions.</li>  <li><code>audio/&#47;</code> representing sound files. <span class="inlineIndicator htmlVer htmlVerInline"><a href="/en-US/docs/HTML/HTML5">HTML5</a></span></li>  <li><code>video/&#47;</code> representing video files. <span class="inlineIndicator htmlVer htmlVerInline"><a href="/en-US/docs/HTML/HTML5">HTML5</a></span></li>  <li><code>image/&#47;</code> representing image files. <span class="inlineIndicator htmlVer htmlVerInline"><a href="/en-US/docs/HTML/HTML5">HTML5</a></span></li> </ul>
 */
object accept extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_accept_attr.type]("accept", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_accept_attr.type]("accept", v)
type attrType = _accept_attr.type

}

object _accept_attr {
@inline implicit def toformApplied(pair: AttrPair[_accept_attr.type]) = pair.asInstanceOf[AttrPair[form.tag.type]]
@inline implicit def toformOptionalApplied(pair: OptionalAttrPair[_accept_attr.type]) = pair.asInstanceOf[OptionalAttrPair[form.tag.type]]
             
@inline implicit def toinputApplied(pair: AttrPair[_accept_attr.type]) = pair.asInstanceOf[AttrPair[input.tag.type]]
@inline implicit def toinputOptionalApplied(pair: OptionalAttrPair[_accept_attr.type]) = pair.asInstanceOf[OptionalAttrPair[input.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_accept_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_accept_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
