package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The URI of a program that processes the form information. This value can be overridden by a <code><a href="/en-US/docs/Web/HTML/Element/button#attr-formaction">formaction</a></code> attribute on a <a title="The HTML <button> element represents a clickable button." href="/en-US/docs/Web/HTML/Element/button"><code>&lt;button&gt;</code></a> or <a title="The HTML <input> element is used to create interactive controls for web-based forms in order to accept data from the user." href="/en-US/docs/Web/HTML/Element/input"><code>&lt;input&gt;</code></a> element.
 */
object action extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_action_attr.type]("action", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_action_attr.type]("action", v)
type attrType = _action_attr.type

}

object _action_attr {
@inline implicit def toformApplied(pair: AttrPair[_action_attr.type]) = pair.asInstanceOf[AttrPair[form.tag.type]]
@inline implicit def toformOptionalApplied(pair: OptionalAttrPair[_action_attr.type]) = pair.asInstanceOf[OptionalAttrPair[form.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_action_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_action_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
