package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * img - This attribute defines the alternative text describing the image. Users will see this text displayed if the image URL is wrong, the image is not in one of the <a href="#Supported_image_formats">supported formats</a>, or if the image is not yet downloaded. <div class="note">  <p>Browsers do not always display the image referenced by the element. This is the case for non-graphical browsers (including those used by people with vision impairments), if the user chooses not to display images, or if the browser cannot display the image because it is invalid or an <a href="#Supported_image_formats">unsupported type</a>. In these cases, the browser may replace the image with the text defined in this element's <code>alt</code> attribute. You should, for these reasons and others, provide a useful value for <code>alt</code> whenever possible.</p> </div> <div class="note">  <p>Omitting this attribute altogether&nbsp;indicates that the image is a key part of the content, and no textual equivalent is available. Setting this attribute to an empty string (<code>alt="")</code> indicates that this image is <em>not</em> a key part of the content, and that&nbsp;non-visual browsers may omit it from rendering.</p> </div>
 * area - A text string alternative to display on browsers that do not display images. The text should be phrased so that it presents the user with the same kind of choice as the image would offer when displayed without the alternative text. In HTML4, this attribute is required, but may be the empty string (""). In HTML5, this attribute is required only if the <strong>href</strong> attribute is used.
 */
object alt extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: String) = new AttrPair[_alt_attr.type]("alt", v)
@inline def :=(v: Option[String]) = new OptionalAttrPair[_alt_attr.type]("alt", v)
type attrType = _alt_attr.type

}

object _alt_attr {
@inline implicit def toareaApplied(pair: AttrPair[_alt_attr.type]) = pair.asInstanceOf[AttrPair[area.tag.type]]
@inline implicit def toareaOptionalApplied(pair: OptionalAttrPair[_alt_attr.type]) = pair.asInstanceOf[OptionalAttrPair[area.tag.type]]
             
@inline implicit def toimgApplied(pair: AttrPair[_alt_attr.type]) = pair.asInstanceOf[AttrPair[img.tag.type]]
@inline implicit def toimgOptionalApplied(pair: OptionalAttrPair[_alt_attr.type]) = pair.asInstanceOf[OptionalAttrPair[img.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_alt_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_alt_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
