package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;area&gt;</code> element</strong> defines a hot-spot region on an image, and optionally associates it with a <a title="hypertext link: Hyperlinks connect webpages or data items to one another. In HTML, <a> elements define hyperlinks from a spot on a webpage (like a text string or image) to another spot on some other webpage (or even on the same page)." class="glossaryLink" href="/en-US/docs/Glossary/Hyperlink">hypertext link</a>. This element is used only within a <a title="The HTML <map> element is used with <area> elements to define an image map (a clickable link area)." href="/en-US/docs/Web/HTML/Element/map"><code>&lt;map&gt;</code></a> element.
 */
object area extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Area
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("area", mods)
}


}

object _area_attr {

}
