package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * A boolean attribute indicating that the browser should, if possible, execute the script asynchronously. This attribute must not be used if the <code>src</code> attribute is absent (i.e. for inline scripts). If it is included&nbsp;in this case it will have no effect.&nbsp;<br> <br> Dynamically inserted scripts execute asynchronously by default, so to turn on synchronous execution (i.e. scripts execute in the order they were loaded) set `async=false` See <a href="#Browser_compatibility">Browser compatibility</a> for notes on browser support. See also <a href="/en-US/docs/Games/Techniques/Async_scripts">Async scripts for asm.js</a>.
 */
object async extends Attr {
implicit object tag extends TagElement {
  type RefType = Nothing
}

@inline def :=(v: Boolean) = new AttrPair[_async_attr.type]("async", v)
@inline def :=(v: Option[Boolean]) = new OptionalAttrPair[_async_attr.type]("async", v)
type attrType = _async_attr.type
@inline implicit def boolToPairscriptApplied(attrObj: this.type) = new AttrPair[script.tag.type]("async", true)
@inline implicit def boolToPairstarApplied(attrObj: this.type) = new AttrPair[*.tag.type]("async", true)
}

object _async_attr {
@inline implicit def toscriptApplied(pair: AttrPair[_async_attr.type]) = pair.asInstanceOf[AttrPair[script.tag.type]]
@inline implicit def toscriptOptionalApplied(pair: OptionalAttrPair[_async_attr.type]) = pair.asInstanceOf[OptionalAttrPair[script.tag.type]]
             
@inline implicit def tostarApplied(pair: AttrPair[_async_attr.type]) = pair.asInstanceOf[AttrPair[*.tag.type]]
@inline implicit def tostarOptionalApplied(pair: OptionalAttrPair[_async_attr.type]) = pair.asInstanceOf[OptionalAttrPair[*.tag.type]]
             
}
