package slinky.web.html

import slinky.core.{AttrPair, OptionalAttrPair, TagElement, Tag, Attr, WithAttrs, TagMod}
import slinky.core.OptionalAttrPair._
import slinky.core.facade.{React, ReactElement}
import scala.scalajs.js
import scala.language.implicitConversions

/**
 * The <strong>HTML <code>&lt;bdo&gt;</code> element</strong> (<em>bidirectional override</em>) is used to override the current directionality of text. It causes the directionality of the characters to be ignored in favor of the specified directionality.
 */
object bdo extends Tag {
implicit object tag extends TagElement {
  type RefType = org.scalajs.dom.html.Element
}
type tagType = tag.type

@inline def apply(mods: TagMod[tag.type]*): WithAttrs[tagType] = {
  WithAttrs("bdo", mods)
}


}

object _bdo_attr {

}
